/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;
import org.springframework.ws.soap.security.callback.CleanupCallback;

public class SpringPlainTextPasswordValidationCallbackHandler
extends AbstractCallbackHandler {
    private AuthenticationManager authenticationManager;
    private boolean ignoreFailure = false;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager is required");
    }

    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof PasswordValidationCallback) {
            PasswordValidationCallback validationCallback = (PasswordValidationCallback)callback;
            if (validationCallback.getRequest() instanceof PasswordValidationCallback.PlainTextPasswordRequest) {
                validationCallback.setValidator((PasswordValidationCallback.PasswordValidator)new SpringSecurityPlainTextPasswordValidator());
                return;
            }
        } else if (callback instanceof CleanupCallback) {
            SecurityContextHolder.clearContext();
            return;
        }
        throw new UnsupportedCallbackException(callback);
    }

    private class SpringSecurityPlainTextPasswordValidator
    implements PasswordValidationCallback.PasswordValidator {
        private SpringSecurityPlainTextPasswordValidator() {
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            PasswordValidationCallback.PlainTextPasswordRequest plainTextRequest = (PasswordValidationCallback.PlainTextPasswordRequest)request;
            try {
                Authentication authResult = SpringPlainTextPasswordValidationCallbackHandler.this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)plainTextRequest.getUsername(), (Object)plainTextRequest.getPassword()));
                if (SpringPlainTextPasswordValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    SpringPlainTextPasswordValidationCallbackHandler.this.logger.debug((Object)("Authentication success: " + authResult.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
                return true;
            }
            catch (AuthenticationException failed) {
                if (SpringPlainTextPasswordValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    SpringPlainTextPasswordValidationCallbackHandler.this.logger.debug((Object)("Authentication request for user '" + plainTextRequest.getUsername() + "' failed: " + failed.toString()));
                }
                SecurityContextHolder.clearContext();
                return SpringPlainTextPasswordValidationCallbackHandler.this.ignoreFailure;
            }
        }
    }
}

