/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.CloseRunnable;
import org.tio.core.GroupContext;
import org.tio.core.PacketSendMode;
import org.tio.core.SynPacketAction;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketWithMeta;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.task.SendRunnable;
import org.tio.utils.lock.ObjWithLock;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.page.Page;
import org.tio.utils.page.PageUtils;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public abstract class Aio {
    private static Logger log = LoggerFactory.getLogger(Aio.class);

    public static void bindGroup(ChannelContext channelContext, String group) {
        channelContext.getGroupContext().groups.bind(group, channelContext);
    }

    public static void bindUser(ChannelContext channelContext, String userid) {
        channelContext.getGroupContext().users.bind(userid, channelContext);
    }

    public static Boolean bSend(ChannelContext channelContext, Packet packet) {
        if (channelContext == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        return Aio.send(channelContext, packet, countDownLatch, PacketSendMode.SINGLE_BLOCK);
    }

    public static Boolean bSend(GroupContext groupContext, String ip, int port, Packet packet) {
        return Aio.send(groupContext, ip, port, packet, true);
    }

    public static Boolean bSendToAll(GroupContext groupContext, Packet packet, ChannelContextFilter channelContextFilter) {
        return Aio.sendToAll(groupContext, packet, channelContextFilter, true);
    }

    public static void bSendToGroup(GroupContext groupContext, String group, Packet packet) {
        Aio.bSendToGroup(groupContext, group, packet, null);
    }

    public static Boolean bSendToGroup(GroupContext groupContext, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        return Aio.sendToGroup(groupContext, group, packet, channelContextFilter, true);
    }

    public static void bSendToId(GroupContext groupContext, String channelId, Packet packet) {
        Aio.sendToId(groupContext, channelId, packet, true);
    }

    public static Boolean bSendToSet(GroupContext groupContext, ObjWithLock<Set<ChannelContext>> setWithLock, Packet packet, ChannelContextFilter channelContextFilter) {
        return Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, true);
    }

    public static Boolean bSendToUser(GroupContext groupContext, String userid, Packet packet) {
        return Aio.sendToUser(groupContext, userid, packet, true);
    }

    public static void close(ChannelContext channelContext, String remark) {
        Aio.close(channelContext, null, remark);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark) {
        Aio.close(channelContext, throwable, remark, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        if (channelContext.isWaitingClose()) {
            log.debug("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", (Object)channelContext);
            return;
        }
        ChannelContext channelContext2 = channelContext;
        synchronized (channelContext2) {
            if (channelContext.isWaitingClose()) {
                log.debug("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", (Object)channelContext);
                return;
            }
            channelContext.setWaitingClose(true);
            SynThreadPoolExecutor closePoolExecutor = channelContext.getGroupContext().getTioExecutor();
            closePoolExecutor.execute(new CloseRunnable(channelContext, throwable, remark, isNeedRemove));
        }
    }

    public static void close(GroupContext groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = groupContext.clientNodeMap.find(clientIp, clientPort);
        Aio.close(channelContext, throwable, remark);
    }

    public static SetWithLock<ChannelContext> getAllChannelContexts(GroupContext groupContext) {
        return groupContext.connections.getSetWithLock();
    }

    public static SetWithLock<ChannelContext> getAllConnectedsChannelContexts(GroupContext groupContext) {
        return groupContext.connecteds.getSetWithLock();
    }

    public static ChannelContext getChannelContextByClientNode(GroupContext groupContext, String clientIp, Integer clientPort) {
        return groupContext.clientNodeMap.find(clientIp, clientPort);
    }

    public static ChannelContext getChannelContextById(GroupContext groupContext, String channelId) {
        return groupContext.ids.find(groupContext, channelId);
    }

    public static ChannelContext getChannelContextByUserid(GroupContext groupContext, String userid) {
        return groupContext.users.find(groupContext, userid);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByGroup(GroupContext groupContext, String group) {
        return groupContext.groups.clients(groupContext, group);
    }

    public static Page<ChannelContext> getPageOfAll(GroupContext groupContext, Integer pageIndex, Integer pageSize) {
        SetWithLock<ChannelContext> setWithLock = Aio.getAllChannelContexts(groupContext);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize);
    }

    public static Page<ChannelContext> getPageOfConnecteds(GroupContext groupContext, Integer pageIndex, Integer pageSize) {
        SetWithLock<ChannelContext> objWithLock = Aio.getAllConnectedsChannelContexts(groupContext);
        return PageUtils.fromSetWithLock(objWithLock, (int)pageIndex, (int)pageSize);
    }

    public static Page<ChannelContext> getPageOfGroup(GroupContext groupContext, String group, Integer pageIndex, Integer pageSize) {
        SetWithLock<ChannelContext> objWithLock = Aio.getChannelContextsByGroup(groupContext, group);
        return PageUtils.fromSetWithLock(objWithLock, (int)pageIndex, (int)pageSize);
    }

    public static void remove(ChannelContext channelContext, String remark) {
        Aio.remove(channelContext, null, remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(GroupContext groupContext, String ip, String remark) {
        SetWithLock<ChannelContext> setWithLock = Aio.getAllChannelContexts(groupContext);
        ReentrantReadWriteLock.ReadLock lock2 = setWithLock.getLock().readLock();
        try {
            lock2.lock();
            Set set = (Set)setWithLock.getObj();
            for (ChannelContext channelContext : set) {
                String clientIp = channelContext.getClientNode().getIp();
                if (!StringUtils.equals((CharSequence)clientIp, (CharSequence)ip)) continue;
                Aio.remove(channelContext, remark);
            }
        }
        finally {
            lock2.unlock();
        }
    }

    public static void remove(ChannelContext channelContext, Throwable throwable, String remark) {
        Aio.close(channelContext, throwable, remark, true);
    }

    public static void remove(GroupContext groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = groupContext.clientNodeMap.find(clientIp, clientPort);
        Aio.remove(channelContext, throwable, remark);
    }

    public static Boolean send(ChannelContext channelContext, Packet packet) {
        return Aio.send(channelContext, packet, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean send(ChannelContext channelContext, Packet packet, CountDownLatch countDownLatch, PacketSendMode packetSendMode) {
        block19: {
            Boolean isSentSuccess;
            PacketWithMeta packetWithMeta;
            SendRunnable sendRunnable;
            boolean isSingleBlock;
            block18: {
                block17: {
                    block16: {
                        if (packet != null) break block16;
                        Boolean bl = false;
                        return bl;
                    }
                    if (channelContext != null && !channelContext.isClosed() && !channelContext.isRemoved()) break block17;
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                    if (channelContext != null) {
                        log.error("{}, isClosed:{}, isRemoved:{}, stack:{} ", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved(), ThreadUtils.stackTrace()});
                    }
                    Boolean bl = false;
                    return bl;
                }
                isSingleBlock = countDownLatch != null && packetSendMode == PacketSendMode.SINGLE_BLOCK;
                sendRunnable = channelContext.getSendRunnable();
                packetWithMeta = null;
                boolean isAdded = false;
                if (countDownLatch == null) {
                    isAdded = sendRunnable.addMsg(packet);
                } else {
                    packetWithMeta = new PacketWithMeta(packet, countDownLatch);
                    isAdded = sendRunnable.addMsg(packetWithMeta);
                }
                if (isAdded) break block18;
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                Boolean bl = false;
                return bl;
            }
            channelContext.getGroupContext().getTioExecutor().execute((Runnable)((Object)sendRunnable));
            if (!isSingleBlock) break block19;
            long timeout = 10L;
            try {
                channelContext.traceBlockPacket(SynPacketAction.BEFORE_WAIT, packet, countDownLatch, null);
                Boolean awaitFlag = countDownLatch.await(timeout, TimeUnit.SECONDS);
                channelContext.traceBlockPacket(SynPacketAction.AFTER__WAIT, packet, countDownLatch, null);
                if (!awaitFlag.booleanValue()) {
                    log.error("{} \u540c\u6b65\u53d1\u9001\u8d85\u65f6, timeout:{}s, packet:{}", new Object[]{channelContext, timeout, packet.logstr()});
                }
            }
            catch (InterruptedException e) {
                log.error(e.toString(), (Throwable)e);
            }
            Boolean bl = isSentSuccess = packetWithMeta.getIsSentSuccess();
            return bl;
        }
        try {
            Boolean bl = null;
            return bl;
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            Boolean bl = null;
            return bl;
        }
    }

    public static Boolean send(GroupContext groupContext, String ip, int port, Packet packet) {
        return Aio.send(groupContext, ip, port, packet, false);
    }

    private static Boolean send(GroupContext groupContext, String ip, int port, Packet packet, boolean isBlock) {
        ChannelContext channelContext = groupContext.clientNodeMap.find(ip, port);
        if (channelContext != null) {
            if (isBlock) {
                return Aio.bSend(channelContext, packet);
            }
            Aio.send(channelContext, packet);
            return null;
        }
        log.info("{}, can find channelContext by {}:{}", new Object[]{groupContext.getName(), ip, port});
        return false;
    }

    public static void sendToAll(GroupContext groupContext, Packet packet) {
        Aio.sendToAll(groupContext, packet, null);
    }

    public static void sendToAll(GroupContext groupContext, Packet packet, ChannelContextFilter channelContextFilter) {
        Aio.sendToAll(groupContext, packet, channelContextFilter, false);
    }

    private static Boolean sendToAll(GroupContext groupContext, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        SetWithLock<ChannelContext> setWithLock = groupContext.connections.getSetWithLock();
        if (setWithLock == null) {
            log.debug("{}, \u6ca1\u6709\u4efb\u4f55\u8fde\u63a5", (Object)groupContext.getName());
            return false;
        }
        return Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isBlock);
    }

    public static void sendToGroup(GroupContext groupContext, String group, Packet packet) {
        Aio.sendToGroup(groupContext, group, packet, null);
    }

    public static void sendToGroup(GroupContext groupContext, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        Aio.sendToGroup(groupContext, group, packet, channelContextFilter, false);
    }

    private static Boolean sendToGroup(GroupContext groupContext, String group, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        SetWithLock<ChannelContext> setWithLock = groupContext.groups.clients(groupContext, group);
        if (setWithLock == null) {
            log.debug("{}, \u7ec4[{}]\u4e0d\u5b58\u5728", (Object)groupContext.getName(), (Object)group);
            return false;
        }
        return Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isBlock);
    }

    public static void bSendToIp(GroupContext groupContext, String ip, Packet packet) {
        Aio.bSendToIp(groupContext, ip, packet, null);
    }

    public static Boolean bSendToIp(GroupContext groupContext, String ip, Packet packet, ChannelContextFilter channelContextFilter) {
        return Aio.sendToIp(groupContext, ip, packet, channelContextFilter, true);
    }

    public static void sendToIp(GroupContext groupContext, String ip, Packet packet) {
        Aio.sendToIp(groupContext, ip, packet, null);
    }

    public static void sendToIp(GroupContext groupContext, String ip, Packet packet, ChannelContextFilter channelContextFilter) {
        Aio.sendToIp(groupContext, ip, packet, channelContextFilter, false);
    }

    private static Boolean sendToIp(GroupContext groupContext, String ip, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        SetWithLock<ChannelContext> setWithLock = groupContext.ips.clients(groupContext, ip);
        if (setWithLock == null) {
            log.info("{}, \u6ca1\u6709ip\u4e3a[{}]\u7684\u5bf9\u7aef", (Object)groupContext.getName(), (Object)ip);
            return false;
        }
        return Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isBlock);
    }

    public static Boolean sendToId(GroupContext groupContext, String channelId, Packet packet) {
        return Aio.sendToId(groupContext, channelId, packet, false);
    }

    private static Boolean sendToId(GroupContext groupContext, String channelId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Aio.getChannelContextById(groupContext, channelId);
        if (channelContext == null) {
            return false;
        }
        if (isBlock) {
            return Aio.bSend(channelContext, packet);
        }
        return Aio.send(channelContext, packet);
    }

    public static void sendToSet(GroupContext groupContext, ObjWithLock<Set<ChannelContext>> setWithLock, Packet packet, ChannelContextFilter channelContextFilter) {
        Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToSet(GroupContext groupContext, ObjWithLock<Set<ChannelContext>> setWithLock, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean sendToUser(GroupContext groupContext, String userid, Packet packet) {
        return Aio.sendToUser(groupContext, userid, packet, false);
    }

    private static Boolean sendToUser(GroupContext groupContext, String userid, Packet packet, boolean isBlock) {
        ChannelContext channelContext = groupContext.users.find(groupContext, userid);
        if (channelContext == null) {
            return false;
        }
        if (isBlock) {
            return Aio.bSend(channelContext, packet);
        }
        return Aio.send(channelContext, packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Packet synSend(ChannelContext channelContext, Packet packet, long timeout) {
        Integer synSeq = packet.getSynSeq();
        if (synSeq == null || synSeq <= 0) {
            throw new RuntimeException("synSeq\u5fc5\u987b\u5927\u4e8e0");
        }
        ChannelContextMapWithLock waitingResps = channelContext.getGroupContext().getWaitingResps();
        try {
            waitingResps.put(synSeq, packet);
            Packet packet2 = packet;
            synchronized (packet2) {
                Aio.send(channelContext, packet);
                try {
                    packet.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            Packet respPacket = waitingResps.remove(synSeq);
            if (respPacket == null) {
                log.error("respPacket == null,{}", (Object)channelContext);
                return null;
            }
            if (respPacket == packet) {
                log.error("{}, \u540c\u6b65\u53d1\u9001\u8d85\u65f6, {}", (Object)channelContext.getGroupContext().getName(), (Object)channelContext);
                return null;
            }
            return respPacket;
        }
    }

    public static void unbindGroup(ChannelContext channelContext) {
        channelContext.getGroupContext().groups.unbind(channelContext);
    }

    public static void unbindGroup(String group, ChannelContext channelContext) {
        channelContext.getGroupContext().groups.unbind(group, channelContext);
    }

    public static void unbindUser(ChannelContext channelContext) {
        channelContext.getGroupContext().users.unbind(channelContext);
    }

    public static void unbindUser(GroupContext groupContext, String userid) {
        groupContext.users.unbind(groupContext, userid);
    }
}

