/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Node
implements Comparable<Node> {
    private String ip;
    private int port;

    public Node(String ip, int port) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            ip = "0.0.0.0";
        }
        this.setIp(ip);
        this.setPort(port);
    }

    @Override
    public int compareTo(Node other) {
        if (other == null) {
            return -1;
        }
        if (Objects.equals(this.ip, other.getIp()) && Objects.equals(this.port, other.getPort())) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Node other = (Node)obj;
        return this.ip.equals(other.getIp()) && this.port == other.getPort();
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return (this.ip + ":" + this.port).hashCode();
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ip).append(":").append(this.port);
        return builder.toString();
    }
}

