/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.stat.IpStat;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.utils.AioUtils;
import org.tio.utils.SystemTimer;

public class ReadCompletionHandler
implements CompletionHandler<Integer, ByteBuffer> {
    private static Logger log = LoggerFactory.getLogger(ReadCompletionHandler.class);
    private ChannelContext channelContext = null;
    private ByteBuffer readByteBuffer;

    public ReadCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.readByteBuffer = ByteBuffer.allocate(channelContext.getGroupContext().getReadBufferSize());
    }

    @Override
    public void completed(Integer result, ByteBuffer byteBuffer) {
        if (result > 0) {
            this.channelContext.getStat().setLatestTimeOfReceivedByte(SystemTimer.currentTimeMillis());
            GroupContext groupContext = this.channelContext.getGroupContext();
            groupContext.getGroupStat().getReceivedBytes().addAndGet(result.intValue());
            this.channelContext.getStat().getReceivedBytes().addAndGet(result.intValue());
            groupContext.getGroupStat().getReceivedTcps().incrementAndGet();
            this.channelContext.getStat().getReceivedTcps().incrementAndGet();
            List<Long> list = groupContext.ipStats.list;
            for (Long v : list) {
                IpStat ipStat = groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                ipStat.getReceivedBytes().addAndGet(result.intValue());
                ipStat.getReceivedTcps().incrementAndGet();
            }
            if (this.channelContext.isTraceClient()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("p_r_buf_len", result);
                this.channelContext.traceClient(ChannelAction.RECEIVED_BUF, null, map);
            }
            DecodeRunnable decodeRunnable = this.channelContext.getDecodeRunnable();
            this.readByteBuffer.flip();
            decodeRunnable.setNewByteBuffer(this.readByteBuffer);
            decodeRunnable.run();
        } else if (result == 0) {
            log.error("{}\u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a0", (Object)this.channelContext);
        } else if (result < 0) {
            if (result == -1) {
                Aio.close(this.channelContext, null, "\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5");
                return;
            }
            Aio.close(this.channelContext, null, "\u8bfb\u6570\u636e\u65f6\u8fd4\u56de" + result);
            return;
        }
        if (AioUtils.checkBeforeIO(this.channelContext)) {
            AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
            this.readByteBuffer.position(0);
            this.readByteBuffer.limit(this.readByteBuffer.capacity());
            asynchronousSocketChannel.read(this.readByteBuffer, this.readByteBuffer, this);
        }
    }

    @Override
    public void failed(Throwable exc, ByteBuffer byteBuffer) {
        Aio.close(this.channelContext, exc, "\u8bfb\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38");
    }

    public ByteBuffer getReadByteBuffer() {
        return this.readByteBuffer;
    }
}

