/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketWithMeta;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.GroupStat;
import org.tio.core.stat.IpStat;
import org.tio.utils.SystemTimer;

public class WriteCompletionHandler
implements CompletionHandler<Integer, WriteCompletionVo> {
    private static Logger log = LoggerFactory.getLogger(WriteCompletionHandler.class);
    private ChannelContext channelContext = null;
    private Semaphore writeSemaphore = new Semaphore(1);

    public WriteCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void completed(Integer result, WriteCompletionVo writeCompletionVo) {
        ByteBuffer byteBuffer = writeCompletionVo.getByteBuffer();
        if (byteBuffer.hasRemaining()) {
            log.info("{} {}/{} has sent", new Object[]{this.channelContext, byteBuffer.position(), byteBuffer.capacity()});
            AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
            asynchronousSocketChannel.write(byteBuffer, writeCompletionVo, this);
            this.channelContext.getStat().setLatestTimeOfSentByte(SystemTimer.currentTimeMillis());
        } else {
            this.channelContext.getStat().setLatestTimeOfSentPacket(SystemTimer.currentTimeMillis());
            this.handle(result, null, writeCompletionVo);
        }
    }

    @Override
    public void failed(Throwable throwable, WriteCompletionVo writeCompletionVo) {
        this.handle(0, throwable, writeCompletionVo);
    }

    public Semaphore getWriteSemaphore() {
        return this.writeSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Integer result, Throwable throwable, WriteCompletionVo writeCompletionVo) {
        this.writeSemaphore.release();
        Object attachment = writeCompletionVo.getObj();
        GroupContext groupContext = this.channelContext.getGroupContext();
        GroupStat groupStat = groupContext.getGroupStat();
        ChannelStat channelStat = this.channelContext.getStat();
        boolean isSentSuccess = result > 0;
        List<Long> list = groupContext.ipStats.list;
        if (isSentSuccess) {
            groupStat.getSentBytes().addAndGet(result.intValue());
            channelStat.getSentBytes().addAndGet(result.intValue());
            for (Long v : list) {
                IpStat ipStat = this.channelContext.getGroupContext().ipStats.get(v, this.channelContext.getClientNode().getIp());
                ipStat.getSentBytes().addAndGet(result.intValue());
            }
        }
        int packetCount = 0;
        try {
            boolean isPacketWithMeta;
            boolean isPacket = attachment instanceof Packet;
            boolean bl = isPacketWithMeta = !isPacket && attachment instanceof PacketWithMeta;
            if (isPacket || isPacketWithMeta) {
                if (isSentSuccess) {
                    groupStat.getSentPacket().incrementAndGet();
                    channelStat.getSentPackets().incrementAndGet();
                    for (Long v : list) {
                        IpStat ipStat = this.channelContext.getGroupContext().ipStats.get(v, this.channelContext.getClientNode().getIp());
                        ipStat.getSentPackets().incrementAndGet();
                    }
                }
                this.handleOne(result, throwable, attachment, isSentSuccess);
            } else {
                List ps = (List)attachment;
                if (isSentSuccess) {
                    packetCount = ps.size();
                    groupStat.getSentPacket().addAndGet(packetCount);
                    channelStat.getSentPackets().addAndGet(packetCount);
                    for (Long v : list) {
                        IpStat ipStat = this.channelContext.getGroupContext().ipStats.get(v, this.channelContext.getClientNode().getIp());
                        ipStat.getSentPackets().addAndGet(packetCount);
                    }
                }
                for (Object obj : ps) {
                    this.handleOne(result, throwable, obj, isSentSuccess);
                }
            }
            if (!isSentSuccess) {
                Aio.close(this.channelContext, throwable, "\u5199\u6570\u636e\u8fd4\u56de:" + result);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void handleOne(Integer result, Throwable throwable, Object obj, Boolean isSentSuccess) {
        Packet packet = null;
        PacketWithMeta packetWithMeta = null;
        boolean isPacket = obj instanceof Packet;
        if (isPacket) {
            packet = (Packet)obj;
        } else {
            packetWithMeta = (PacketWithMeta)obj;
            packetWithMeta.setIsSentSuccess(isSentSuccess);
            packet = packetWithMeta.getPacket();
        }
        try {
            this.channelContext.traceClient(ChannelAction.AFTER_SEND, packet, null);
            this.channelContext.processAfterSent(obj, isSentSuccess);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public static class WriteCompletionVo {
        private ByteBuffer byteBuffer = null;
        private Object obj = null;

        public WriteCompletionVo(ByteBuffer byteBuffer, Object obj) {
            this.byteBuffer = byteBuffer;
            this.obj = obj;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public Object getObj() {
            return this.obj;
        }

        public void setByteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public void setObj(Object obj) {
            this.obj = obj;
        }
    }
}

