/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import com.google.common.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.cache.IpStatRemovalListener;
import org.tio.core.intf.IpStatListener;
import org.tio.core.stat.IpStat;
import org.tio.utils.cache.guava.GuavaCache;

public class IpStats {
    private static Logger log = LoggerFactory.getLogger(IpStats.class);
    private static final String CACHE_NAME = "TIO_IP_STAT";
    private String groupContextId;
    private GroupContext groupContext;
    public final Map<Long, GuavaCache> map = new HashMap<Long, GuavaCache>();
    public final List<Long> list = new ArrayList<Long>();

    public IpStats(GroupContext groupContext, IpStatListener ipStatListener, Long[] ipStatDurations) {
        this.groupContext = groupContext;
        this.groupContextId = groupContext.getId();
        if (ipStatDurations != null) {
            for (Long ipStatDuration : ipStatDurations) {
                this.addMonitor(ipStatDuration, ipStatListener);
            }
        }
    }

    public void addMonitor(Long ipStatDuration, IpStatListener ipStatListener) {
        GuavaCache guavaCache = GuavaCache.register((String)this.getCacheName(ipStatDuration), (Long)ipStatDuration, null, (RemovalListener)new IpStatRemovalListener(this.groupContext, ipStatListener));
        this.map.put(ipStatDuration, guavaCache);
        this.list.add(ipStatDuration);
    }

    public void addMonitors(Long[] ipStatDurations, IpStatListener ipStatListener) {
        if (ipStatDurations != null) {
            for (Long ipStatDuration : ipStatDurations) {
                this.addMonitor(ipStatDuration, ipStatListener);
            }
        }
    }

    public void removeMonitor(Long ipStatDuration) {
        this.clear(ipStatDuration);
        this.map.remove(ipStatDuration);
        this.list.remove(ipStatDuration);
    }

    public String getCacheName(Long ipStatDuration) {
        String cacheName = "TIO_IP_STAT_" + this.groupContextId + "_";
        return cacheName + ipStatDuration;
    }

    public void clear(Long ipStatDuration) {
        GuavaCache guavaCache = this.map.get(ipStatDuration);
        if (guavaCache == null) {
            return;
        }
        guavaCache.clear();
    }

    public IpStat get(Long ipStatDuration, String ip) {
        return this.get(ipStatDuration, ip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpStat get(Long ipStatDuration, String ip, boolean forceCreate) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        GuavaCache guavaCache = this.map.get(ipStatDuration);
        if (guavaCache == null) {
            return null;
        }
        IpStat ipStat = (IpStat)guavaCache.get(ip);
        if (ipStat == null && forceCreate) {
            IpStats ipStats = this;
            synchronized (ipStats) {
                ipStat = (IpStat)guavaCache.get(ip);
                if (ipStat == null) {
                    ipStat = new IpStat(ip, ipStatDuration);
                    guavaCache.put(ip, (Serializable)ipStat);
                }
            }
        }
        return ipStat;
    }

    public ConcurrentMap<String, Serializable> map(Long ipStatDuration) {
        GuavaCache guavaCache = this.map.get(ipStatDuration);
        if (guavaCache == null) {
            return null;
        }
        ConcurrentMap map = guavaCache.asMap();
        return map;
    }

    public Long size(Long ipStatDuration) {
        GuavaCache guavaCache = this.map.get(ipStatDuration);
        if (guavaCache == null) {
            return null;
        }
        return guavaCache.size();
    }

    public Collection<Serializable> values(Long ipStatDuration) {
        GuavaCache guavaCache = this.map.get(ipStatDuration);
        if (guavaCache == null) {
            return null;
        }
        Collection<Serializable> set = guavaCache.asMap().values();
        return set;
    }
}

