/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class Ips {
    private static Logger log = LoggerFactory.getLogger(Ips.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> ipmap = new MapWithLock(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(ChannelContext channelContext) {
        if (channelContext == null) {
            return;
        }
        String ip = channelContext.getClientNode().getIp();
        if ("$UNKNOWN".equals(ip)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)ip)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock1 = this.ipmap.getLock().writeLock();
        SetWithLock channelContexts = null;
        try {
            lock1.lock();
            Map map = (Map)this.ipmap.getObj();
            channelContexts = (SetWithLock)map.get(ip);
            if (channelContexts == null) {
                channelContexts = new SetWithLock(new HashSet());
                map.put(ip, channelContexts);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            lock1.unlock();
        }
        ReentrantReadWriteLock.WriteLock lock11 = channelContexts.getLock().writeLock();
        try {
            lock11.lock();
            ((Set)channelContexts.getObj()).add(channelContext);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            lock11.unlock();
        }
    }

    public SetWithLock<ChannelContext> clients(GroupContext groupContext, String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        Map map = (Map)this.ipmap.getObj();
        SetWithLock set = (SetWithLock)map.get(ip);
        return set;
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getIpmap() {
        return this.ipmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unbind(ChannelContext channelContext) {
        if (channelContext == null) {
            return;
        }
        String ip = channelContext.getClientNode().getIp();
        if ("$UNKNOWN".equals(ip)) {
            log.error("{} ip is not right", (Object)channelContext);
            return;
        }
        GroupContext groupContext = channelContext.getGroupContext();
        if (StringUtils.isBlank((CharSequence)ip)) {
            return;
        }
        SetWithLock channelContexts = (SetWithLock)((Map)this.ipmap.getObj()).get(ip);
        if (channelContexts != null) {
            ReentrantReadWriteLock.WriteLock lock1 = channelContexts.getLock().writeLock();
            try {
                lock1.lock();
                ((Set)channelContexts.getObj()).remove((Object)channelContext);
                if (((Set)channelContexts.getObj()).size() != 0) return;
                ReentrantReadWriteLock.WriteLock lock2 = this.ipmap.getLock().writeLock();
                try {
                    lock2.lock();
                    ((Map)this.ipmap.getObj()).remove(ip);
                    return;
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                    return;
                }
                finally {
                    lock2.unlock();
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
                return;
            }
            finally {
                lock1.unlock();
            }
        } else {
            log.error("{}, ip\u3010{}\u3011 \u627e\u4e0d\u5230\u5bf9\u5e94\u7684SetWithLock", (Object)groupContext.getName(), (Object)ip);
        }
    }
}

