/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.utils.lock.ObjWithLock;

public class Users {
    private ObjWithLock<DualHashBidiMap<String, ChannelContext>> map = new ObjWithLock((Object)new DualHashBidiMap());

    public void bind(String userid, ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)userid)) {
            return;
        }
        String key = userid;
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            m.put((Object)key, (Object)channelContext);
            channelContext.setUserid(userid);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext find(GroupContext groupContext, String userid) {
        if (groupContext.isShortConnection()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)userid)) {
            return null;
        }
        String key = userid;
        ReentrantReadWriteLock.ReadLock lock = this.map.getLock().readLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            ChannelContext channelContext = (ChannelContext)((Object)m.get((Object)key));
            return channelContext;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ObjWithLock<DualHashBidiMap<String, ChannelContext>> getMap() {
        return this.map;
    }

    public void unbind(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            m.removeValue((Object)channelContext);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext unbind(GroupContext groupContext, String userid) {
        if (groupContext.isShortConnection()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)userid)) {
            return null;
        }
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            ChannelContext channelContext = (ChannelContext)((Object)m.remove((Object)userid));
            return channelContext;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

