/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import java.nio.channels.AsynchronousSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.utils.thread.ThreadUtils;

public class AioUtils {
    private static Logger log = LoggerFactory.getLogger(AioUtils.class);

    public static boolean checkBeforeIO(ChannelContext channelContext) {
        boolean isClosed = channelContext.isClosed();
        boolean isRemoved = channelContext.isRemoved();
        boolean isWaitingClose = channelContext.isWaitingClose();
        if (isWaitingClose) {
            return false;
        }
        AsynchronousSocketChannel asynchronousSocketChannel = channelContext.getAsynchronousSocketChannel();
        Boolean isopen = null;
        if (asynchronousSocketChannel != null) {
            isopen = asynchronousSocketChannel.isOpen();
            if (isClosed || isRemoved) {
                if (isopen.booleanValue()) {
                    try {
                        Aio.close(channelContext, "asynchronousSocketChannel is open, but channelContext isClosed: " + isClosed + ", isRemoved: " + isRemoved);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                log.info("{}, isopen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed(), channelContext.isRemoved()});
                return false;
            }
        } else {
            log.error("{}, \u8bf7\u68c0\u67e5\u6b64\u5f02\u5e38, asynchronousSocketChannel is null, isClosed:{}, isRemoved:{}, {} ", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved(), ThreadUtils.stackTrace()});
            return false;
        }
        if (!isopen.booleanValue()) {
            log.info("{}, \u53ef\u80fd\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5, isopen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed(), channelContext.isRemoved()});
            Aio.close(channelContext, "asynchronousSocketChannel is not open, \u53ef\u80fd\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5");
            return false;
        }
        return true;
    }
}

