/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.GroupStat;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.DefaultServerAioListener;
import org.tio.server.ServerGroupStat;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.SystemTimer;
import org.tio.utils.json.Json;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class ServerGroupContext
extends GroupContext {
    static Logger log = LoggerFactory.getLogger(ServerGroupContext.class);
    private AcceptCompletionHandler acceptCompletionHandler = null;
    private ServerAioHandler serverAioHandler = null;
    private ServerAioListener serverAioListener = null;
    protected ServerGroupStat serverGroupStat = new ServerGroupStat();
    private Thread checkHeartbeatThread = null;

    public ServerGroupContext(ServerAioHandler serverAioHandler, ServerAioListener serverAioListener) {
        this(null, serverAioHandler, serverAioListener);
    }

    public ServerGroupContext(String name, ServerAioHandler serverAioHandler, ServerAioListener serverAioListener) {
        this(name, serverAioHandler, serverAioListener, null, null);
    }

    public ServerGroupContext(ServerAioHandler serverAioHandler, ServerAioListener serverAioListener, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this(null, serverAioHandler, serverAioListener, tioExecutor, groupExecutor);
    }

    public ServerGroupContext(String name, ServerAioHandler serverAioHandler, ServerAioListener serverAioListener, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        super(tioExecutor, groupExecutor);
        this.name = name;
        this.acceptCompletionHandler = new AcceptCompletionHandler();
        this.serverAioHandler = serverAioHandler;
        this.serverAioListener = serverAioListener == null ? new DefaultServerAioListener() : serverAioListener;
        this.checkHeartbeatThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                while (!ServerGroupContext.this.isStopped()) {
                    long iv;
                    SetWithLock<ChannelContext> objwithlock;
                    if (ServerGroupContext.this.heartbeatTimeout <= 0L) {
                        log.info("{}, \u7528\u6237\u53d6\u6d88\u4e86\u6846\u67b6\u5c42\u9762\u7684\u5fc3\u8df3\u68c0\u6d4b\uff0c\u5982\u679c\u4e1a\u52a1\u9700\u8981\uff0c\u8bf7\u7528\u6237\u81ea\u5df1\u53bb\u5b8c\u6210\u5fc3\u8df3\u68c0\u6d4b", (Object)ServerGroupContext.this.name);
                        break;
                    }
                    try {
                        Thread.sleep(ServerGroupContext.this.heartbeatTimeout);
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    long start = SystemTimer.currentTimeMillis();
                    SetWithLock<ChannelContext> objWithLock = ServerGroupContext.this.connections.getSetWithLock();
                    Set set = null;
                    ReentrantReadWriteLock.ReadLock readLock = objWithLock.getLock().readLock();
                    long start1 = 0L;
                    int count = 0;
                    readLock.lock();
                    start1 = SystemTimer.currentTimeMillis();
                    set = (Set)objWithLock.getObj();
                    for (ChannelContext entry : set) {
                        ++count;
                        ChannelContext channelContext = entry;
                        ChannelStat stat = channelContext.getStat();
                        long timeLatestReceivedMsg = stat.getLatestTimeOfReceivedByte();
                        long timeLatestSentMsg = stat.getLatestTimeOfSentPacket();
                        long compareTime = Math.max(timeLatestReceivedMsg, timeLatestSentMsg);
                        long currtime = SystemTimer.currentTimeMillis();
                        long interval = currtime - compareTime;
                        if (interval <= ServerGroupContext.this.heartbeatTimeout) continue;
                        log.info("{}, {} ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f", (Object)channelContext, (Object)interval);
                        Aio.remove(channelContext, interval + " ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f");
                    }
                    try {
                        readLock.unlock();
                        if (log.isInfoEnabled()) {
                            int groups = 0;
                            objwithlock = ServerGroupContext.this.groups.clients(ServerGroupContext.this, "g");
                            if (objwithlock != null) {
                                groups = ((Set)objwithlock.getObj()).size();
                            }
                            log.info("{}, [{}]:[{}]\r\n\u5f53\u524d\u8fde\u63a5\u4e2a\u6570                                 {}\r\n\u5f53\u524d\u5171\u6709 \u4e0d\u540c\u7684ip\u6570      {}\r\n\u7fa4\u7ec4(g)                 {}\r\n\u5171\u63a5\u53d7\u8fde\u63a5                                      {}\r\n\u4e00\u5171\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u4e2a\u6570            {}\r\n\u5df2\u63a5\u6536\u6d88\u606f                                   ({}p)({}b)\r\n\u5df2\u5904\u7406\u6d88\u606f                                     {}p\r\n\u5df2\u53d1\u9001\u6d88\u606f                                      ({}p)({}b)\r\n\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570   {}\r\n\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305   {}\r\n\u76ee\u524dIP\u7edf\u8ba1\u7684\u65f6\u957f   {}", new Object[]{ServerGroupContext.this.name, SystemTimer.currentTimeMillis(), ServerGroupContext.this.id, set.size(), ((Map)ServerGroupContext.this.ips.getIpmap().getObj()).size(), groups, ServerGroupContext.this.serverGroupStat.getAccepted().get(), ServerGroupContext.this.serverGroupStat.getClosed().get(), ServerGroupContext.this.serverGroupStat.getReceivedPackets().get(), ServerGroupContext.this.serverGroupStat.getReceivedBytes().get(), ServerGroupContext.this.serverGroupStat.getHandledPacket().get(), ServerGroupContext.this.serverGroupStat.getSentPacket().get(), ServerGroupContext.this.serverGroupStat.getSentBytes().get(), ServerGroupContext.this.serverGroupStat.getBytesPerTcpReceive(), ServerGroupContext.this.serverGroupStat.getPacketsPerTcpReceive(), Json.toJson(ServerGroupContext.this.ipStats.list)});
                        }
                        if (log.isInfoEnabled()) {
                            log.info("{}, \r\nclientNodes:{}\r\n\u6240\u6709\u8fde\u63a5:{}\r\n\u76ee\u524d\u8fde\u4e0a\u7684\u8fde\u63a5:{}\r\n\u5173\u95ed\u7684\u8fde\u63a5\u6b21\u6570:{}\r\n\u7fa4\u7ec4:[channelmap:{}, groupmap:{}]\r\n\u7ed1\u5b9a\u7528\u6237\u6570:{}\r\n\u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94:{}\r\n\u88ab\u62c9\u9ed1\u7684ip:{}", new Object[]{ServerGroupContext.this.name, ((DualHashBidiMap)ServerGroupContext.this.clientNodeMap.getMap().getObj()).size(), ((Set)ServerGroupContext.this.connections.getSetWithLock().getObj()).size(), ((Set)ServerGroupContext.this.connecteds.getSetWithLock().getObj()).size(), ((Set)ServerGroupContext.this.closeds.getSetWithLock().getObj()).size(), ((Map)ServerGroupContext.this.groups.getChannelmap().getObj()).size(), ((Map)ServerGroupContext.this.groups.getGroupmap().getObj()).size(), ((DualHashBidiMap)ServerGroupContext.this.users.getMap().getObj()).size(), ((Map)ServerGroupContext.this.waitingResps.getMap().getObj()).size(), Json.toJson(ServerGroupContext.this.ipBlacklist.getCopy())});
                        }
                        if (!log.isInfoEnabled()) continue;
                        long end = SystemTimer.currentTimeMillis();
                        long iv1 = start1 - start;
                        iv = end - start1;
                        log.info("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{ServerGroupContext.this.name, count, iv1, iv, ServerGroupContext.this.heartbeatTimeout});
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    continue;
                    catch (Throwable e) {
                        try {
                            log.error("", e);
                        }
                        catch (Throwable throwable) {
                            try {
                                readLock.unlock();
                                if (log.isInfoEnabled()) {
                                    int groups = 0;
                                    SetWithLock<ChannelContext> objwithlock2 = ServerGroupContext.this.groups.clients(ServerGroupContext.this, "g");
                                    if (objwithlock2 != null) {
                                        groups = ((Set)objwithlock2.getObj()).size();
                                    }
                                    log.info("{}, [{}]:[{}]\r\n\u5f53\u524d\u8fde\u63a5\u4e2a\u6570                                 {}\r\n\u5f53\u524d\u5171\u6709 \u4e0d\u540c\u7684ip\u6570      {}\r\n\u7fa4\u7ec4(g)                 {}\r\n\u5171\u63a5\u53d7\u8fde\u63a5                                      {}\r\n\u4e00\u5171\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u4e2a\u6570            {}\r\n\u5df2\u63a5\u6536\u6d88\u606f                                   ({}p)({}b)\r\n\u5df2\u5904\u7406\u6d88\u606f                                     {}p\r\n\u5df2\u53d1\u9001\u6d88\u606f                                      ({}p)({}b)\r\n\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570   {}\r\n\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305   {}\r\n\u76ee\u524dIP\u7edf\u8ba1\u7684\u65f6\u957f   {}", new Object[]{ServerGroupContext.this.name, SystemTimer.currentTimeMillis(), ServerGroupContext.this.id, set.size(), ((Map)ServerGroupContext.this.ips.getIpmap().getObj()).size(), groups, ServerGroupContext.this.serverGroupStat.getAccepted().get(), ServerGroupContext.this.serverGroupStat.getClosed().get(), ServerGroupContext.this.serverGroupStat.getReceivedPackets().get(), ServerGroupContext.this.serverGroupStat.getReceivedBytes().get(), ServerGroupContext.this.serverGroupStat.getHandledPacket().get(), ServerGroupContext.this.serverGroupStat.getSentPacket().get(), ServerGroupContext.this.serverGroupStat.getSentBytes().get(), ServerGroupContext.this.serverGroupStat.getBytesPerTcpReceive(), ServerGroupContext.this.serverGroupStat.getPacketsPerTcpReceive(), Json.toJson(ServerGroupContext.this.ipStats.list)});
                                }
                                if (log.isInfoEnabled()) {
                                    log.info("{}, \r\nclientNodes:{}\r\n\u6240\u6709\u8fde\u63a5:{}\r\n\u76ee\u524d\u8fde\u4e0a\u7684\u8fde\u63a5:{}\r\n\u5173\u95ed\u7684\u8fde\u63a5\u6b21\u6570:{}\r\n\u7fa4\u7ec4:[channelmap:{}, groupmap:{}]\r\n\u7ed1\u5b9a\u7528\u6237\u6570:{}\r\n\u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94:{}\r\n\u88ab\u62c9\u9ed1\u7684ip:{}", new Object[]{ServerGroupContext.this.name, ((DualHashBidiMap)ServerGroupContext.this.clientNodeMap.getMap().getObj()).size(), ((Set)ServerGroupContext.this.connections.getSetWithLock().getObj()).size(), ((Set)ServerGroupContext.this.connecteds.getSetWithLock().getObj()).size(), ((Set)ServerGroupContext.this.closeds.getSetWithLock().getObj()).size(), ((Map)ServerGroupContext.this.groups.getChannelmap().getObj()).size(), ((Map)ServerGroupContext.this.groups.getGroupmap().getObj()).size(), ((DualHashBidiMap)ServerGroupContext.this.users.getMap().getObj()).size(), ((Map)ServerGroupContext.this.waitingResps.getMap().getObj()).size(), Json.toJson(ServerGroupContext.this.ipBlacklist.getCopy())});
                                }
                                if (log.isInfoEnabled()) {
                                    long end = SystemTimer.currentTimeMillis();
                                    long iv1 = start1 - start;
                                    long iv2 = end - start1;
                                    log.info("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{ServerGroupContext.this.name, count, iv1, iv2, ServerGroupContext.this.heartbeatTimeout});
                                }
                            }
                            catch (Exception e2) {
                                log.error("", (Throwable)e2);
                            }
                            throw throwable;
                        }
                        try {
                            readLock.unlock();
                            if (log.isInfoEnabled()) {
                                int groups = 0;
                                objwithlock = ServerGroupContext.this.groups.clients(ServerGroupContext.this, "g");
                                if (objwithlock != null) {
                                    groups = ((Set)objwithlock.getObj()).size();
                                }
                                log.info("{}, [{}]:[{}]\r\n\u5f53\u524d\u8fde\u63a5\u4e2a\u6570                                 {}\r\n\u5f53\u524d\u5171\u6709 \u4e0d\u540c\u7684ip\u6570      {}\r\n\u7fa4\u7ec4(g)                 {}\r\n\u5171\u63a5\u53d7\u8fde\u63a5                                      {}\r\n\u4e00\u5171\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u4e2a\u6570            {}\r\n\u5df2\u63a5\u6536\u6d88\u606f                                   ({}p)({}b)\r\n\u5df2\u5904\u7406\u6d88\u606f                                     {}p\r\n\u5df2\u53d1\u9001\u6d88\u606f                                      ({}p)({}b)\r\n\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570   {}\r\n\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305   {}\r\n\u76ee\u524dIP\u7edf\u8ba1\u7684\u65f6\u957f   {}", new Object[]{ServerGroupContext.this.name, SystemTimer.currentTimeMillis(), ServerGroupContext.this.id, set.size(), ((Map)ServerGroupContext.this.ips.getIpmap().getObj()).size(), groups, ServerGroupContext.this.serverGroupStat.getAccepted().get(), ServerGroupContext.this.serverGroupStat.getClosed().get(), ServerGroupContext.this.serverGroupStat.getReceivedPackets().get(), ServerGroupContext.this.serverGroupStat.getReceivedBytes().get(), ServerGroupContext.this.serverGroupStat.getHandledPacket().get(), ServerGroupContext.this.serverGroupStat.getSentPacket().get(), ServerGroupContext.this.serverGroupStat.getSentBytes().get(), ServerGroupContext.this.serverGroupStat.getBytesPerTcpReceive(), ServerGroupContext.this.serverGroupStat.getPacketsPerTcpReceive(), Json.toJson(ServerGroupContext.this.ipStats.list)});
                            }
                            if (log.isInfoEnabled()) {
                                log.info("{}, \r\nclientNodes:{}\r\n\u6240\u6709\u8fde\u63a5:{}\r\n\u76ee\u524d\u8fde\u4e0a\u7684\u8fde\u63a5:{}\r\n\u5173\u95ed\u7684\u8fde\u63a5\u6b21\u6570:{}\r\n\u7fa4\u7ec4:[channelmap:{}, groupmap:{}]\r\n\u7ed1\u5b9a\u7528\u6237\u6570:{}\r\n\u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94:{}\r\n\u88ab\u62c9\u9ed1\u7684ip:{}", new Object[]{ServerGroupContext.this.name, ((DualHashBidiMap)ServerGroupContext.this.clientNodeMap.getMap().getObj()).size(), ((Set)ServerGroupContext.this.connections.getSetWithLock().getObj()).size(), ((Set)ServerGroupContext.this.connecteds.getSetWithLock().getObj()).size(), ((Set)ServerGroupContext.this.closeds.getSetWithLock().getObj()).size(), ((Map)ServerGroupContext.this.groups.getChannelmap().getObj()).size(), ((Map)ServerGroupContext.this.groups.getGroupmap().getObj()).size(), ((DualHashBidiMap)ServerGroupContext.this.users.getMap().getObj()).size(), ((Map)ServerGroupContext.this.waitingResps.getMap().getObj()).size(), Json.toJson(ServerGroupContext.this.ipBlacklist.getCopy())});
                            }
                            if (!log.isInfoEnabled()) continue;
                            long end = SystemTimer.currentTimeMillis();
                            long iv1 = start1 - start;
                            iv = end - start1;
                            log.info("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{ServerGroupContext.this.name, count, iv1, iv, ServerGroupContext.this.heartbeatTimeout});
                        }
                        catch (Exception e3) {
                            log.error("", (Throwable)e3);
                        }
                    }
                }
            }
        }, "tio-timer-checkheartbeat-" + this.id);
        this.checkHeartbeatThread.setDaemon(true);
        this.checkHeartbeatThread.setPriority(1);
        this.checkHeartbeatThread.start();
    }

    public AcceptCompletionHandler getAcceptCompletionHandler() {
        return this.acceptCompletionHandler;
    }

    @Override
    public AioHandler getAioHandler() {
        return this.getServerAioHandler();
    }

    @Override
    public AioListener getAioListener() {
        return this.getServerAioListener();
    }

    @Override
    public GroupStat getGroupStat() {
        return this.getServerGroupStat();
    }

    public ServerAioHandler getServerAioHandler() {
        return this.serverAioHandler;
    }

    public ServerAioListener getServerAioListener() {
        return this.serverAioListener;
    }

    public ServerGroupStat getServerGroupStat() {
        return this.serverGroupStat;
    }

    public void setServerAioListener(ServerAioListener serverAioListener) {
        this.serverAioListener = serverAioListener;
    }
}

