/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.thymeleaf.IThrottledTemplateProcessor;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.engine.DataDrivenTemplateIterator;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.spring5.ISpringWebReactiveTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.context.reactive.IReactiveDataDriverContextVariable;
import org.thymeleaf.spring5.context.reactive.ISpringWebReactiveContext;
import org.thymeleaf.spring5.context.reactive.SpringWebReactiveEngineContextFactory;
import org.thymeleaf.spring5.linkbuilder.reactive.SpringWebReactiveLinkBuilder;
import org.thymeleaf.util.LoggingUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class SpringWebReactiveTemplateEngine
extends SpringTemplateEngine
implements ISpringWebReactiveTemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(SpringWebReactiveTemplateEngine.class);
    private static final String LOG_CATEGORY_FULL_OUTPUT = SpringWebReactiveTemplateEngine.class.getName() + ".DOWNSTREAM.FULL";
    private static final String LOG_CATEGORY_CHUNKED_OUTPUT = SpringWebReactiveTemplateEngine.class.getName() + ".DOWNSTREAM.CHUNKED";
    private static final String LOG_CATEGORY_DATADRIVEN_INPUT = SpringWebReactiveTemplateEngine.class.getName() + ".UPSTREAM.DATA-DRIVEN";
    private static final String LOG_CATEGORY_DATADRIVEN_OUTPUT = SpringWebReactiveTemplateEngine.class.getName() + ".DOWNSTREAM.DATA-DRIVEN";

    public SpringWebReactiveTemplateEngine() {
        this.setEngineContextFactory(new SpringWebReactiveEngineContextFactory());
        this.setLinkBuilder((ILinkBuilder)new SpringWebReactiveLinkBuilder());
    }

    @Override
    public Publisher<DataBuffer> processStream(String template, Set<String> markupSelectors, IContext context, DataBufferFactory bufferFactory, Charset charset) {
        return this.processStream(template, markupSelectors, context, bufferFactory, charset, Integer.MAX_VALUE);
    }

    @Override
    public Publisher<DataBuffer> processStream(String template, Set<String> markupSelectors, IContext context, DataBufferFactory bufferFactory, Charset charset, int responseMaxChunkSizeBytes) {
        if (template == null) {
            return Flux.error((Throwable)new IllegalArgumentException("Template cannot be null"));
        }
        if (context == null) {
            return Flux.error((Throwable)new IllegalArgumentException("Context cannot be null"));
        }
        if (bufferFactory == null) {
            return Flux.error((Throwable)new IllegalArgumentException("Buffer Factory cannot be null"));
        }
        if (charset == null) {
            return Flux.error((Throwable)new IllegalArgumentException("Charset cannot be null"));
        }
        if (responseMaxChunkSizeBytes == 0) {
            return Flux.error((Throwable)new IllegalArgumentException("Max Chunk Size cannot be zero"));
        }
        int chunkSizeBytes = responseMaxChunkSizeBytes < 0 ? Integer.MAX_VALUE : responseMaxChunkSizeBytes;
        try {
            String dataDriverVariableName = SpringWebReactiveTemplateEngine.findDataDriverInModel(context);
            if (dataDriverVariableName != null) {
                return this.createDataDrivenStream(template, markupSelectors, context, dataDriverVariableName, bufferFactory, charset, chunkSizeBytes);
            }
        }
        catch (Throwable t) {
            return Flux.error((Throwable)t);
        }
        if (chunkSizeBytes == Integer.MAX_VALUE) {
            return this.createFullStream(template, markupSelectors, context, bufferFactory, charset);
        }
        return this.createChunkedStream(template, markupSelectors, context, bufferFactory, charset, responseMaxChunkSizeBytes);
    }

    private Mono<DataBuffer> createFullStream(String templateName, Set<String> markupSelectors, IContext context, DataBufferFactory bufferFactory, Charset charset) {
        Mono stream = Mono.create(subscriber -> {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] STARTING STREAM PROCESS (FULL MODE) OF TEMPLATE \"{}\" WITH LOCALE {}", new Object[]{TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale()});
            }
            DataBuffer dataBuffer = bufferFactory.allocateBuffer();
            OutputStreamWriter writer = new OutputStreamWriter(dataBuffer.asOutputStream(), charset);
            try {
                this.process(templateName, markupSelectors, context, writer);
            }
            catch (Throwable t) {
                logger.error(String.format("[THYMELEAF][%s] Exception processing template \"%s\": %s", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName((String)templateName), t.getMessage()), t);
                subscriber.error(t);
                return;
            }
            int bytesProduced = dataBuffer.readableByteCount();
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] FINISHED STREAM PROCESS (FULL MODE) OF TEMPLATE \"{}\" WITH LOCALE {}. PRODUCED {} BYTES", new Object[]{TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale(), bytesProduced});
            }
            subscriber.success((Object)dataBuffer);
        });
        return stream.log(LOG_CATEGORY_FULL_OUTPUT, Level.FINEST, new SignalType[0]);
    }

    private Flux<DataBuffer> createChunkedStream(String templateName, Set<String> markupSelectors, IContext context, DataBufferFactory bufferFactory, Charset charset, int responseMaxChunkSizeBytes) {
        Flux stream = Flux.generate(() -> new CountingThrottledTemplateProcessor(this.processThrottled(templateName, markupSelectors, context)), (throttledProcessor, emitter) -> {
            int bytesProduced;
            throttledProcessor.startChunk();
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}][{}] STARTING PARTIAL STREAM PROCESS (CHUNKED MODE, THROTTLER ID \"{}\", CHUNK {}) FOR TEMPLATE \"{}\" WITH LOCALE {}", new Object[]{TemplateEngine.threadIndex(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getChunkCount(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale()});
            }
            DataBuffer buffer = bufferFactory.allocateBuffer(responseMaxChunkSizeBytes);
            try {
                bytesProduced = throttledProcessor.process(responseMaxChunkSizeBytes, buffer.asOutputStream(), charset);
            }
            catch (Throwable t) {
                emitter.error(t);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}][{}] FINISHED PARTIAL STREAM PROCESS (CHUNKED MODE, THROTTLER ID \"{}\", CHUNK {}) FOR TEMPLATE \"{}\" WITH LOCALE {}. PRODUCED {} BYTES", new Object[]{TemplateEngine.threadIndex(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getChunkCount(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale(), bytesProduced});
            }
            emitter.next((Object)buffer);
            if (throttledProcessor.isFinished()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][{}][{}] FINISHED ALL STREAM PROCESS (CHUNKED MODE, THROTTLER ID \"{}\") FOR TEMPLATE \"{}\" WITH LOCALE {}. PRODUCED A TOTAL OF {} BYTES IN {} CHUNKS", new Object[]{TemplateEngine.threadIndex(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getProcessorIdentifier(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale(), throttledProcessor.getTotalBytesProduced(), throttledProcessor.getChunkCount() + 1});
                }
                emitter.complete();
            }
            return throttledProcessor;
        });
        return stream.log(LOG_CATEGORY_CHUNKED_OUTPUT, Level.FINEST, new SignalType[0]);
    }

    private Flux<DataBuffer> createDataDrivenStream(String templateName, Set<String> markupSelectors, IContext context, String dataDriverVariableName, DataBufferFactory bufferFactory, Charset charset, int responseMaxChunkSizeBytes) {
        IReactiveDataDriverContextVariable dataDriver = (IReactiveDataDriverContextVariable)context.getVariable(dataDriverVariableName);
        DataDrivenTemplateIterator dataDrivenIterator = new DataDrivenTemplateIterator();
        IContext wrappedContext = SpringWebReactiveTemplateEngine.applyDataDriverWrapper(context, dataDriverVariableName, dataDrivenIterator);
        Flux dataDrivenBufferedStream = Flux.from(dataDriver.getDataStream()).buffer(dataDriver.getBufferSizeElements()).log(LOG_CATEGORY_DATADRIVEN_INPUT, Level.FINEST, new SignalType[0]);
        Flux dataDrivenWithContextStream = Flux.using(() -> new CountingThrottledTemplateProcessor(this.processThrottled(templateName, markupSelectors, wrappedContext)), throttledProcessor -> Flux.concat((Publisher)Flux.generate(() -> DataDrivenFluxStep.FluxStepPhase.DATA_DRIVEN_PHASE_HEAD, (phase, emitter) -> {
            if (throttledProcessor.isFinished()) {
                emitter.complete();
                return null;
            }
            switch (phase) {
                case DATA_DRIVEN_PHASE_HEAD: {
                    emitter.next((Object)Mono.just((Object)DataDrivenFluxStep.forHead(throttledProcessor)));
                    return DataDrivenFluxStep.FluxStepPhase.DATA_DRIVEN_PHASE_BUFFER;
                }
                case DATA_DRIVEN_PHASE_BUFFER: {
                    emitter.next((Object)dataDrivenBufferedStream.map(values -> DataDrivenFluxStep.forBuffer(throttledProcessor, values)));
                    return DataDrivenFluxStep.FluxStepPhase.DATA_DRIVEN_PHASE_TAIL;
                }
                case DATA_DRIVEN_PHASE_TAIL: {
                    emitter.next((Object)Mono.just((Object)DataDrivenFluxStep.forTail(throttledProcessor)));
                    emitter.complete();
                }
            }
            return null;
        })), throttledProcessor -> {});
        Flux stream = dataDrivenWithContextStream.concatMap(step -> Flux.generate(() -> Boolean.TRUE, (initialize, emitter) -> {
            int bytesProduced;
            CountingThrottledTemplateProcessor throttledProcessor = step.getThrottledProcessor();
            if (throttledProcessor.isFinished()) {
                emitter.complete();
                return Boolean.FALSE;
            }
            if (initialize.booleanValue()) {
                if (step.isHead()) {
                    dataDrivenIterator.feedBuffer(Collections.emptyList());
                } else if (step.isDataBuffer()) {
                    dataDrivenIterator.feedBuffer(step.getValues());
                } else {
                    dataDrivenIterator.feedingComplete();
                }
            }
            throttledProcessor.startChunk();
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}][{}] STARTING PARTIAL STREAM PROCESS (DATA-DRIVEN MODE, THROTTLER ID \"{}\", CHUNK {}) FOR TEMPLATE \"{}\" WITH LOCALE {}", new Object[]{TemplateEngine.threadIndex(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getChunkCount(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale()});
            }
            DataBuffer buffer = responseMaxChunkSizeBytes != Integer.MAX_VALUE ? bufferFactory.allocateBuffer(responseMaxChunkSizeBytes) : bufferFactory.allocateBuffer();
            try {
                bytesProduced = throttledProcessor.process(responseMaxChunkSizeBytes, buffer.asOutputStream(), charset);
            }
            catch (Throwable t) {
                emitter.error(t);
                return Boolean.FALSE;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}][{}] FINISHED PARTIAL STREAM PROCESS (DATA-DRIVEN MODE, THROTTLER ID \"{}\", CHUNK {}) FOR TEMPLATE \"{}\" WITH LOCALE {}. PRODUCED {} BYTES", new Object[]{TemplateEngine.threadIndex(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getChunkCount(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale(), bytesProduced});
            }
            emitter.next((Object)buffer);
            if (throttledProcessor.isFinished()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][{}][{}] FINISHED ALL STREAM PROCESS (DATA-DRIVEN MODE, THROTTLER ID \"{}\") FOR TEMPLATE \"{}\" WITH LOCALE {}. PRODUCED A TOTAL OF {} BYTES IN {} CHUNKS", new Object[]{TemplateEngine.threadIndex(), throttledProcessor.getProcessorIdentifier(), throttledProcessor.getProcessorIdentifier(), LoggingUtils.loggifyTemplateName((String)templateName), context.getLocale(), throttledProcessor.getTotalBytesProduced(), throttledProcessor.getChunkCount() + 1});
                }
                emitter.complete();
            } else if (step.isHead() && dataDrivenIterator.hasBeenQueried()) {
                emitter.complete();
            } else if (step.isDataBuffer() && !dataDrivenIterator.continueBufferExecution()) {
                emitter.complete();
            }
            return Boolean.FALSE;
        }));
        return stream.log(LOG_CATEGORY_DATADRIVEN_OUTPUT, Level.FINEST, new SignalType[0]);
    }

    private static IContext applyDataDriverWrapper(IContext context, String dataDriverVariableName, DataDrivenTemplateIterator dataDrivenTemplateIterator) {
        if (context instanceof IEngineContext) {
            ((IEngineContext)context).setVariable(dataDriverVariableName, (Object)dataDrivenTemplateIterator);
            return context;
        }
        if (context instanceof ISpringWebReactiveContext) {
            return new DataDrivenSpringWebReactiveContextWrapper((ISpringWebReactiveContext)context, dataDriverVariableName, dataDrivenTemplateIterator);
        }
        return new DataDrivenContextWrapper(context, dataDriverVariableName, dataDrivenTemplateIterator);
    }

    private static String findDataDriverInModel(IContext context) {
        String dataDriverVariableName = null;
        Set contextVariableNames = context.getVariableNames();
        for (String contextVariableName : contextVariableNames) {
            Object contextVariableValue = context.getVariable(contextVariableName);
            if (!(contextVariableValue instanceof IReactiveDataDriverContextVariable)) continue;
            if (dataDriverVariableName != null) {
                throw new TemplateProcessingException("Only one data-driver variable is allowed to be specified as a model attribute, but at least two have been identified: '" + dataDriverVariableName + "' and '" + contextVariableName + "'");
            }
            dataDriverVariableName = contextVariableName;
        }
        return dataDriverVariableName;
    }

    static class DataDrivenContextWrapper
    implements IContext {
        private final IContext context;
        private final String dataDriverVariableName;
        private final DataDrivenTemplateIterator dataDrivenTemplateIterator;

        DataDrivenContextWrapper(IContext context, String dataDriverVariableName, DataDrivenTemplateIterator dataDrivenTemplateIterator) {
            this.context = context;
            this.dataDriverVariableName = dataDriverVariableName;
            this.dataDrivenTemplateIterator = dataDrivenTemplateIterator;
        }

        public IContext getWrappedContext() {
            return this.context;
        }

        public Locale getLocale() {
            return this.context.getLocale();
        }

        public boolean containsVariable(String name) {
            return this.context.containsVariable(name);
        }

        public Set<String> getVariableNames() {
            return this.context.getVariableNames();
        }

        public Object getVariable(String name) {
            if (this.dataDriverVariableName.equals(name)) {
                return this.dataDrivenTemplateIterator;
            }
            return this.context.getVariable(name);
        }
    }

    static class DataDrivenSpringWebReactiveContextWrapper
    extends DataDrivenContextWrapper
    implements ISpringWebReactiveContext {
        private final ISpringWebReactiveContext context;

        DataDrivenSpringWebReactiveContextWrapper(ISpringWebReactiveContext context, String dataDriverVariableName, DataDrivenTemplateIterator dataDrivenTemplateIterator) {
            super(context, dataDriverVariableName, dataDrivenTemplateIterator);
            this.context = context;
        }

        @Override
        public ServerHttpRequest getRequest() {
            return this.context.getRequest();
        }

        @Override
        public ServerHttpResponse getResponse() {
            return this.context.getResponse();
        }

        @Override
        public Mono<WebSession> getSession() {
            return this.context.getSession();
        }

        @Override
        public ServerWebExchange getExchange() {
            return this.context.getExchange();
        }
    }

    static final class DataDrivenFluxStep {
        private final CountingThrottledTemplateProcessor throttledProcessor;
        private final List<Object> values;
        private final FluxStepPhase phase;

        static DataDrivenFluxStep forHead(CountingThrottledTemplateProcessor throttledProcessor) {
            return new DataDrivenFluxStep(throttledProcessor, null, FluxStepPhase.DATA_DRIVEN_PHASE_HEAD);
        }

        static DataDrivenFluxStep forBuffer(CountingThrottledTemplateProcessor throttledProcessor, List<Object> values) {
            return new DataDrivenFluxStep(throttledProcessor, values, FluxStepPhase.DATA_DRIVEN_PHASE_BUFFER);
        }

        static DataDrivenFluxStep forTail(CountingThrottledTemplateProcessor throttledProcessor) {
            return new DataDrivenFluxStep(throttledProcessor, null, FluxStepPhase.DATA_DRIVEN_PHASE_TAIL);
        }

        private DataDrivenFluxStep(CountingThrottledTemplateProcessor throttledProcessor, List<Object> values, FluxStepPhase phase) {
            this.throttledProcessor = throttledProcessor;
            this.values = values;
            this.phase = phase;
        }

        CountingThrottledTemplateProcessor getThrottledProcessor() {
            return this.throttledProcessor;
        }

        List<Object> getValues() {
            return this.values;
        }

        boolean isHead() {
            return this.phase == FluxStepPhase.DATA_DRIVEN_PHASE_HEAD;
        }

        boolean isDataBuffer() {
            return this.phase == FluxStepPhase.DATA_DRIVEN_PHASE_BUFFER;
        }

        boolean isTail() {
            return this.phase == FluxStepPhase.DATA_DRIVEN_PHASE_TAIL;
        }

        static enum FluxStepPhase {
            DATA_DRIVEN_PHASE_HEAD,
            DATA_DRIVEN_PHASE_BUFFER,
            DATA_DRIVEN_PHASE_TAIL;

        }
    }

    static class CountingThrottledTemplateProcessor {
        private final IThrottledTemplateProcessor throttledProcessor;
        private int chunkCount;
        private long totalBytesProduced;

        CountingThrottledTemplateProcessor(IThrottledTemplateProcessor throttledProcessor) {
            this.throttledProcessor = throttledProcessor;
            this.chunkCount = -1;
            this.totalBytesProduced = 0L;
        }

        int process(int maxOutputInBytes, OutputStream outputStream, Charset charset) {
            int chunkBytes = this.throttledProcessor.process(maxOutputInBytes, outputStream, charset);
            this.totalBytesProduced += (long)chunkBytes;
            return chunkBytes;
        }

        String getProcessorIdentifier() {
            return this.throttledProcessor.getProcessorIdentifier();
        }

        boolean isFinished() {
            return this.throttledProcessor.isFinished();
        }

        void startChunk() {
            ++this.chunkCount;
        }

        int getChunkCount() {
            return this.chunkCount;
        }

        long getTotalBytesProduced() {
            return this.totalBytesProduced;
        }
    }
}

