/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.reactive;

import java.util.Collections;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapterRegistry;
import org.thymeleaf.context.ILazyContextVariable;
import org.thymeleaf.context.LazyContextVariable;
import org.thymeleaf.spring5.context.reactive.ReactiveContextVariableUtils;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveLazyContextVariable
extends LazyContextVariable<Object>
implements ILazyContextVariable<Object> {
    private final Object asyncObject;
    private ReactiveAdapterRegistry adapterRegistry;

    public ReactiveLazyContextVariable(Object asyncObject) {
        Validate.notNull((Object)asyncObject, (String)"Lazy context variable value cannot be null");
        this.asyncObject = asyncObject;
        this.adapterRegistry = null;
    }

    public final void setReactiveAdapterRegistry(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.adapterRegistry = reactiveAdapterRegistry;
    }

    protected final Object loadValue() {
        Publisher<Object> publisher = ReactiveContextVariableUtils.computePublisherValue(this.asyncObject, this.adapterRegistry);
        if (publisher instanceof Flux) {
            return ((Flux)publisher).collectList().defaultIfEmpty(Collections.emptyList()).block();
        }
        return ((Mono)publisher).block();
    }
}

