/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.reactive;

import java.util.Map;
import java.util.Optional;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.spring5.context.IThymeleafRequestDataValueProcessor;

class SpringWebReactiveThymeleafRequestDataValueProcessor
implements IThymeleafRequestDataValueProcessor {
    private final RequestDataValueProcessor requestDataValueProcessor;
    private final ServerWebExchange exchange;

    SpringWebReactiveThymeleafRequestDataValueProcessor(Optional<RequestDataValueProcessor> requestDataValueProcessor, ServerWebExchange exchange) {
        this.requestDataValueProcessor = requestDataValueProcessor.orElse(null);
        this.exchange = exchange;
    }

    @Override
    public String processAction(String action, String httpMethod) {
        if (this.requestDataValueProcessor == null) {
            return action;
        }
        return this.requestDataValueProcessor.processAction(this.exchange, action, httpMethod);
    }

    @Override
    public String processFormFieldValue(String name, String value, String type) {
        if (this.requestDataValueProcessor == null) {
            return value;
        }
        return this.requestDataValueProcessor.processFormFieldValue(this.exchange, name, value, type);
    }

    @Override
    public Map<String, String> getExtraHiddenFields() {
        if (this.requestDataValueProcessor == null) {
            return null;
        }
        return this.requestDataValueProcessor.getExtraHiddenFields(this.exchange);
    }

    @Override
    public String processUrl(String url) {
        if (this.requestDataValueProcessor == null) {
            return url;
        }
        return this.requestDataValueProcessor.processUrl(this.exchange, url);
    }
}

