/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.ExtendedAttributeView;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;

public abstract class AbstractBasicFileAttributeView<P extends Path>
implements BasicFileAttributeView,
ExtendedAttributeView {
    static final String IS_REGULAR_FILE = "isRegularFile";
    static final String IS_DIRECTORY = "isDirectory";
    static final String IS_SYMBOLIC_LINK = "isSymbolicLink";
    static final String IS_OTHER = "isOther";
    static final String SIZE = "size";
    static final String FILE_KEY = "fileKey";
    static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    static final String LAST_ACCESS_TIME = "lastAccessTime";
    static final String CREATION_TIME = "creationTime";
    private static final Set<String> PROPERTIES = new HashSet<String>(){
        {
            this.add(AbstractBasicFileAttributeView.IS_REGULAR_FILE);
            this.add(AbstractBasicFileAttributeView.IS_DIRECTORY);
            this.add(AbstractBasicFileAttributeView.IS_SYMBOLIC_LINK);
            this.add(AbstractBasicFileAttributeView.IS_OTHER);
            this.add(AbstractBasicFileAttributeView.SIZE);
            this.add(AbstractBasicFileAttributeView.FILE_KEY);
            this.add(AbstractBasicFileAttributeView.LAST_MODIFIED_TIME);
            this.add(AbstractBasicFileAttributeView.LAST_ACCESS_TIME);
            this.add(AbstractBasicFileAttributeView.CREATION_TIME);
        }
    };
    protected final P path;

    public AbstractBasicFileAttributeView(P path) {
        this.path = (Path)Preconditions.checkNotNull((String)"path", path);
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, Object> readAllAttributes() {
        return this.readAttributes("*");
    }

    @Override
    public Map<String, Object> readAttributes(final String ... attributes) {
        final Object attrs = this.readAttributes();
        return new HashMap<String, Object>(){
            {
                for (String attribute : attributes) {
                    Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.IS_REGULAR_FILE)) {
                        this.put(AbstractBasicFileAttributeView.IS_REGULAR_FILE, attrs.isRegularFile());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.IS_DIRECTORY)) {
                        this.put(AbstractBasicFileAttributeView.IS_DIRECTORY, attrs.isDirectory());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.IS_SYMBOLIC_LINK)) {
                        this.put(AbstractBasicFileAttributeView.IS_SYMBOLIC_LINK, attrs.isSymbolicLink());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.IS_OTHER)) {
                        this.put(AbstractBasicFileAttributeView.IS_OTHER, attrs.isOther());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.SIZE)) {
                        this.put(AbstractBasicFileAttributeView.SIZE, new Long(attrs.size()));
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.FILE_KEY)) {
                        this.put(AbstractBasicFileAttributeView.FILE_KEY, attrs.fileKey());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.LAST_MODIFIED_TIME)) {
                        this.put(AbstractBasicFileAttributeView.LAST_MODIFIED_TIME, attrs.lastModifiedTime());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.LAST_ACCESS_TIME)) {
                        this.put(AbstractBasicFileAttributeView.LAST_ACCESS_TIME, attrs.lastAccessTime());
                    }
                    if (attribute.equals("*") || attribute.equals(AbstractBasicFileAttributeView.CREATION_TIME)) {
                        this.put(AbstractBasicFileAttributeView.CREATION_TIME, attrs.creationTime());
                    }
                    if (attribute.equals("*")) break;
                }
            }
        };
    }

    @Override
    public void setAttribute(String attribute, Object value) throws IOException {
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        Preconditions.checkCondition((String)"invalid attribute", (boolean)PROPERTIES.contains(attribute));
        throw new NotImplementedException();
    }

    @Override
    public boolean isSerializable() {
        return false;
    }
}

