/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jasperreports;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jasperreports.IDatabaseConnectionProvider;
import org.wicketstuff.jasperreports.IJasperReportFactory;

public abstract class JRResource
extends AbstractResource {
    private static Logger log = LoggerFactory.getLogger(JRResource.class);
    private IDatabaseConnectionProvider connectionProvider;
    private IJasperReportFactory jasperReportFactory;
    private transient JasperReport jasperReport;
    private Map<String, Object> reportParameters;
    private JRDataSource reportDataSource;
    private String fileName;

    public JRResource() {
    }

    public JRResource(final InputStream report) {
        this(new IJasperReportFactory(){

            @Override
            public JasperReport newJasperReport() throws JRException {
                return (JasperReport)JRLoader.loadObject((InputStream)report);
            }
        });
    }

    public JRResource(final URL report) {
        this(new IJasperReportFactory(){

            @Override
            public JasperReport newJasperReport() throws JRException {
                return (JasperReport)JRLoader.loadObject((URL)report);
            }
        });
    }

    public JRResource(final File report) {
        this(new IJasperReportFactory(){

            @Override
            public JasperReport newJasperReport() throws JRException {
                return (JasperReport)JRLoader.loadObject((File)report);
            }
        });
    }

    public JRResource(IJasperReportFactory factory) {
        this.jasperReportFactory = factory;
    }

    public JasperReport getJasperReport() {
        if (this.jasperReport == null && this.jasperReportFactory != null) {
            try {
                this.setJasperReport(this.jasperReportFactory.newJasperReport());
            }
            catch (JRException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return this.jasperReport;
    }

    public final void setJasperReport(JasperReport report) {
        this.jasperReport = report;
    }

    public Map<String, Object> getReportParameters() {
        return new HashMap<String, Object>(this.reportParameters);
    }

    public final JRResource setReportParameters(Map<String, Object> params) {
        this.reportParameters = params;
        return this;
    }

    public JRDataSource getReportDataSource() {
        return this.reportDataSource;
    }

    public JRResource setReportDataSource(JRDataSource dataSource) {
        this.reportDataSource = dataSource;
        return this;
    }

    public IDatabaseConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public final JRResource setConnectionProvider(IDatabaseConnectionProvider provider) {
        this.connectionProvider = provider;
        return this;
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.getJasperReport().getName() + "." + this.getExtension();
        }
        return this.fileName;
    }

    public final JRResource setFileName(String name) {
        this.fileName = name;
        return this;
    }

    public abstract JRAbstractExporter newExporter();

    public abstract String getContentType();

    public ContentDisposition getContentDisposition() {
        return ContentDisposition.ATTACHMENT;
    }

    public abstract String getExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JasperPrint newJasperPrint() throws JRException {
        JasperPrint jasperPrint;
        JasperReport report = this.getJasperReport();
        Map<String, Object> params = this.getReportParameters();
        JRDataSource dataSource = this.getReportDataSource();
        if (dataSource != null) {
            jasperPrint = JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)dataSource);
        } else {
            IDatabaseConnectionProvider provider = null;
            try {
                provider = this.getConnectionProvider();
                if (provider == null) {
                    throw new IllegalStateException("JasperReportsResources must either have a JRDataSource, or a JDBC Connection provided");
                }
                jasperPrint = JasperFillManager.fillReport((JasperReport)report, params, (Connection)provider.get());
            }
            finally {
                if (provider != null) {
                    provider.release();
                }
            }
        }
        return jasperPrint;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resp = new AbstractResource.ResourceResponse();
        resp.disableCaching();
        resp.setContentType(this.getContentType());
        resp.setFileName(this.getFileName());
        resp.setContentDisposition(this.getContentDisposition());
        if (resp.dataNeedsToBeWritten(attributes)) {
            resp.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) {
                    try {
                        long t1 = System.currentTimeMillis();
                        JasperPrint print = JRResource.this.newJasperPrint();
                        JRAbstractExporter exporter = JRResource.this.newExporter();
                        byte[] data = JRResource.this.getExporterData(print, exporter);
                        attributes.getResponse().write(data);
                        if (log.isDebugEnabled()) {
                            long t2 = System.currentTimeMillis();
                            log.debug("loaded report data; bytes: " + data.length + " in " + (t2 - t1) + " miliseconds");
                        }
                    }
                    catch (JRException e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
            });
        }
        return resp;
    }

    protected byte[] getExporterData(JasperPrint print, JRAbstractExporter exporter) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos.toByteArray();
    }
}

