/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcher;

class LdapUserSearcherFactory {
    protected static final int searchTimeLimit = 10000;

    LdapUserSearcherFactory() {
    }

    static LdapSearcher<LdapEntry, String> createForUsernameIsDn() {
        return new LdapSearcher<LdapEntry, String>(){

            @Override
            public LdapEntry search(DirContext dirContext, String suppliedName) {
                return new LdapEntry(suppliedName, suppliedName);
            }
        };
    }

    static LdapSearcher<LdapEntry, String> createForUsernameFilter(String baseDn, boolean recursive, String userDnAttribute, String attribute, String usernameLoad) {
        return new LdapUserSearcherImpl(baseDn, recursive, userDnAttribute, attribute, null, usernameLoad);
    }

    static LdapSearcher<LdapEntry, String> createForAdvancedFilter(String baseDn, boolean recursive, String userDnAttribute, String filter, String usernameLoad) {
        return new LdapUserSearcherImpl(baseDn, recursive, userDnAttribute, null, filter, usernameLoad);
    }

    private static class LdapUserSearcherImpl
    implements LdapSearcher<LdapEntry, String> {
        final String baseDn;
        final boolean recursive;
        final String userDnAttribute;
        final String userNameAttribute;
        final String advancedFilter;
        final String usernameLoad;

        private LdapUserSearcherImpl(String baseDn, boolean recursive, String userDnAttribute, String userNameAttribute, String advancedFilter, String usernameLoad) {
            this.baseDn = baseDn;
            this.recursive = recursive;
            this.userDnAttribute = userDnAttribute;
            this.userNameAttribute = userNameAttribute;
            this.advancedFilter = advancedFilter;
            this.usernameLoad = usernameLoad;
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl baseDn=%s", baseDn);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl recursive=%b", recursive);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl userDnAttribute=%s", userDnAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl userNameAttribute=%s", userNameAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl advancedFilter=%s", advancedFilter);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl usernameLoad=%s", usernameLoad);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LdapEntry search(DirContext dirContext, String suppliedName) throws IOException, NamingException {
            NamingEnumeration<SearchResult> searchEnumeration = null;
            try {
                SearchControls searchControls = new SearchControls();
                if (this.recursive) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing recursive search");
                    searchControls.setSearchScope(2);
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing single level search");
                    searchControls.setSearchScope(1);
                }
                if (this.usernameLoad == null) {
                    searchControls.setReturningAttributes(new String[]{this.userDnAttribute});
                } else {
                    searchControls.setReturningAttributes(new String[]{this.userDnAttribute, this.usernameLoad});
                }
                searchControls.setTimeLimit(10000);
                Object[] filterArguments = new Object[]{suppliedName};
                String filter = this.userNameAttribute != null ? "(" + this.userNameAttribute + "={0})" : this.advancedFilter;
                DomainManagementLogger.SECURITY_LOGGER.tracef("Searching for user '%s' using filter '%s'.", suppliedName, filter);
                searchEnumeration = dirContext.search(this.baseDn, filter, filterArguments, searchControls);
                if (!searchEnumeration.hasMore()) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in directory.", suppliedName);
                    throw DomainManagementMessages.MESSAGES.userNotFoundInDirectory(suppliedName);
                }
                String distinguishedUserDN = null;
                String username = this.usernameLoad == null ? suppliedName : null;
                SearchResult result = searchEnumeration.next();
                Attributes attributes = result.getAttributes();
                if (attributes != null) {
                    Attribute usernameAttr;
                    Attribute dn = attributes.get(this.userDnAttribute);
                    if (dn != null) {
                        distinguishedUserDN = (String)dn.get();
                    }
                    if (this.usernameLoad != null && (usernameAttr = attributes.get(this.usernameLoad)) != null) {
                        username = (String)usernameAttr.get();
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Converted username '%s' to '%s'", suppliedName, username);
                    }
                }
                if (distinguishedUserDN == null) {
                    if (result.isRelative()) {
                        distinguishedUserDN = result.getName() + ("".equals(this.baseDn) ? "" : "," + this.baseDn);
                    } else {
                        String name = result.getName();
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Can't follow referral for authentication: %s", name);
                        throw DomainManagementMessages.MESSAGES.nameNotFound(suppliedName);
                    }
                }
                if (username == null) {
                    throw DomainManagementMessages.MESSAGES.usernameNotLoaded(suppliedName);
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("DN '%s' found for user '%s'", distinguishedUserDN, username);
                LdapEntry ldapEntry = new LdapEntry(username, distinguishedUserDN);
                return ldapEntry;
            }
            finally {
                if (searchEnumeration != null) {
                    try {
                        searchEnumeration.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
    }
}

