/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.AddUserFailedException;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;

public class ErrorState
implements State {
    private final State nextState;
    private final String errorMessage;
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public ErrorState(ConsoleWrapper theConsole, String errorMessage) {
        this(theConsole, errorMessage, null, null);
    }

    public ErrorState(ConsoleWrapper theConsole, String errorMessage, State nextState) {
        this(theConsole, errorMessage, nextState, null);
    }

    public ErrorState(ConsoleWrapper theConsole, String errorMessage, State nextState, StateValues stateValues) {
        this.errorMessage = errorMessage;
        this.nextState = nextState;
        this.stateValues = stateValues;
        this.theConsole = theConsole;
    }

    @Override
    public State execute() {
        boolean direct = this.theConsole.getConsole() == null;
        this.printf(AddUser.NEW_LINE, direct);
        this.printf(" * ", direct);
        this.printf(DomainManagementMessages.MESSAGES.errorHeader(), direct);
        this.printf(" * ", direct);
        this.printf(AddUser.NEW_LINE, direct);
        this.printf(this.errorMessage, direct);
        this.printf(AddUser.NEW_LINE, direct);
        this.printf(AddUser.NEW_LINE, direct);
        if (this.stateValues != null && !this.stateValues.isInteractive() && this.nextState == null) {
            throw new AddUserFailedException(this.errorMessage);
        }
        return this.nextState;
    }

    private void printf(String message, boolean direct) {
        if (direct) {
            System.err.print(message);
        } else {
            this.theConsole.printf(message, new Object[0]);
        }
    }
}

