/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.logging;

import java.util.List;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYJSF", length=4)
public interface JSFLogger
extends BasicLogger {
    public static final JSFLogger ROOT_LOGGER = (JSFLogger)Logger.getMessageLogger(JSFLogger.class, (String)"org.jboss.as.jsf");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="WildFlyConversationAwareViewHandler was improperly initialized. Expected ViewHandler parent.")
    public void viewHandlerImproperlyInitialized();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Could not load JSF managed bean class: %s")
    public void managedBeanLoadFail(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="JSF managed bean class %s has no default constructor")
    public void managedBeanNoDefaultConstructor(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Failed to parse %s, managed beans defined in this file will not be available")
    public void managedBeansConfigParseFailed(VirtualFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Unknown JSF version '%s'.  Default version '%s' will be used instead.")
    public void unknownJSFVersion(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="JSF version slot '%s' is missing from module %s")
    public void missingJSFModule(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Activated the following JSF Implementations: %s")
    public void activatedJSFImplementations(List var1);

    @Message(id=8, value="Failed to load annotated class: %s")
    public String classLoadingFailed(DotName var1);

    @Message(id=9, value="Annotation %s in class %s is only allowed on classes")
    public String invalidAnnotationLocation(Object var1, AnnotationTarget var2);

    @Message(id=13, value="@ManagedBean is only allowed at class level %s")
    public String invalidManagedBeanAnnotation(AnnotationTarget var1);

    @Message(id=14, value="Default JSF implementation slot '%s' is invalid")
    public DeploymentUnitProcessingException invalidDefaultJSFImpl(String var1);
}

