/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceAwareObjectFactory;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ObjectFactoryBuilder
implements javax.naming.spi.ObjectFactoryBuilder,
DirObjectFactory {
    public static final ObjectFactoryBuilder INSTANCE = new ObjectFactoryBuilder();

    private ObjectFactoryBuilder() {
    }

    @Override
    public ObjectFactory createObjectFactory(Object obj, Hashtable<?, ?> environment) throws NamingException {
        try {
            if (obj instanceof Reference) {
                return this.factoryFromReference((Reference)obj, environment);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        if (classLoader == null) {
            return ref;
        }
        String factoriesProp = (String)environment.get("java.naming.factory.object");
        if (factoriesProp != null) {
            String[] classes;
            for (String className : classes = factoriesProp.split(":")) {
                try {
                    Class<?> factoryClass = classLoader.loadClass(className);
                    ObjectFactory objectFactory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
                    Object result = objectFactory.getObjectInstance(ref, name, nameCtx, environment);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attributes) throws Exception {
        ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        if (classLoader == null) {
            return ref;
        }
        String factoriesProp = (String)environment.get("java.naming.factory.object");
        if (factoriesProp != null) {
            String[] classes;
            for (String className : classes = factoriesProp.split(":")) {
                try {
                    Class<?> factoryClass = classLoader.loadClass(className);
                    ObjectFactory objectFactory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
                    Object result = objectFactory instanceof DirObjectFactory ? ((DirObjectFactory)DirObjectFactory.class.cast(objectFactory)).getObjectInstance(ref, name, nameCtx, environment, attributes) : objectFactory.getObjectInstance(ref, name, nameCtx, environment);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
        }
        return ref;
    }

    private ObjectFactory factoryFromReference(Reference reference, Hashtable<?, ?> environment) throws Exception {
        if (reference.getFactoryClassName() == null) {
            return ObjectFactoryBuilder.lookForURLs(reference, environment);
        }
        if (reference instanceof ModularReference) {
            return this.factoryFromModularReference((ModularReference)ModularReference.class.cast(reference), environment);
        }
        return this.factoryFromReference(reference, WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), environment);
    }

    private ObjectFactory factoryFromModularReference(ModularReference modularReference, Hashtable<?, ?> environment) throws Exception {
        Module module = Module.getCallerModuleLoader().loadModule(modularReference.getModuleIdentifier());
        ModuleClassLoader classLoader = module.getClassLoader();
        return this.factoryFromReference(modularReference, (ClassLoader)classLoader, environment);
    }

    private ObjectFactory factoryFromReference(Reference reference, ClassLoader classLoader, Hashtable<?, ?> environment) throws Exception {
        try {
            Class<?> factoryClass = classLoader.loadClass(reference.getFactoryClassName());
            ObjectFactory factory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
            if (factory instanceof ServiceAwareObjectFactory) {
                ((ServiceAwareObjectFactory)factory).injectServiceRegistry((ServiceRegistry)ObjectFactoryBuilder.currentServiceContainer());
            }
            return factory;
        }
        catch (Throwable t) {
            throw NamingMessages.MESSAGES.objectFactoryCreationFailure(t);
        }
    }

    static ObjectFactory lookForURLs(Reference ref, Hashtable environment) throws NamingException {
        for (int i = 0; i < ref.size(); ++i) {
            String url;
            ObjectFactory answer;
            RefAddr addr = ref.get(i);
            if (!(addr instanceof StringRefAddr) || !addr.getType().equalsIgnoreCase("URL") || (answer = ObjectFactoryBuilder.processURL(url = (String)addr.getContent(), environment)) == null) continue;
            return answer;
        }
        return null;
    }

    private static ObjectFactory processURL(Object refInfo, Hashtable environment) throws NamingException {
        ObjectFactory answer;
        String url;
        String scheme;
        if (refInfo instanceof String && (scheme = ObjectFactoryBuilder.getURLScheme(url = (String)refInfo)) != null && (answer = ObjectFactoryBuilder.getURLObjectFactory(scheme, url, environment)) != null) {
            return answer;
        }
        if (refInfo instanceof String[]) {
            String[] urls = (String[])refInfo;
            for (int i = 0; i < urls.length; ++i) {
                ObjectFactory answer2;
                String scheme2 = ObjectFactoryBuilder.getURLScheme(urls[i]);
                if (scheme2 == null || (answer2 = ObjectFactoryBuilder.getURLObjectFactory(scheme2, urls[i], environment)) == null) continue;
                return answer2;
            }
        }
        return null;
    }

    private static ObjectFactory getURLObjectFactory(String scheme, String url, Hashtable environment) throws NamingException {
        String facProp = (String)environment.get("java.naming.factory.url.pkgs");
        facProp = facProp != null ? facProp + ":com.sun.jndi.url" : "com.sun.jndi.url";
        ClassLoader loader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        String suffix = "." + scheme + "." + scheme + "URLContextFactory";
        StringTokenizer parser = new StringTokenizer(facProp, ":");
        ObjectFactory factory = null;
        while (parser.hasMoreTokens()) {
            String className = parser.nextToken() + suffix;
            try {
                Class<?> clazz = loader == null ? Class.forName(className) : Class.forName(className, true, loader);
                return new ReferenceUrlContextFactoryWrapper((ObjectFactory)clazz.newInstance(), url);
            }
            catch (IllegalAccessException | InstantiationException e) {
                NamingException ne = new NamingException(className);
                ne.setRootCause(e);
                throw ne;
            }
            catch (Exception e) {
            }
        }
        return factory;
    }

    private static String getURLScheme(String str) {
        int colon = str.indexOf(58);
        int slash = str.indexOf(47);
        if (colon > 0 && (slash == -1 || colon + 1 == slash)) {
            return str.substring(0, colon);
        }
        return null;
    }

    private static ServiceContainer currentServiceContainer() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }

    private static final class ReferenceUrlContextFactoryWrapper
    implements ObjectFactory {
        private final ObjectFactory factory;
        private final String url;

        private ReferenceUrlContextFactoryWrapper(ObjectFactory factory, String url) {
            this.factory = factory;
            this.url = url;
        }

        @Override
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
            return this.factory.getObjectInstance(this.url, name, nameCtx, environment);
        }
    }
}

