/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.sp;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.picketlink.federation.config.SPConfiguration;
import org.wildfly.extension.picketlink.federation.model.AbstractEntityProviderAddHandler;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderRemoveHandler;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.ServiceProviderService;

public class ServiceProviderAddHandler
extends AbstractEntityProviderAddHandler {
    public static final ServiceProviderAddHandler INSTANCE = new ServiceProviderAddHandler();

    private ServiceProviderAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : ServiceProviderResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attribute.validateAndSet(operation, model);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        super.execute(context, operation);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ModelNode serviceProviderNode = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ServiceProviderAddHandler.launchService(context, pathAddress, serviceProviderNode);
    }

    static void launchService(OperationContext context, PathAddress pathAddress, ModelNode model) throws OperationFailedException {
        String alias = pathAddress.getLastElement().getValue();
        ServiceProviderService service = new ServiceProviderService(ServiceProviderAddHandler.toSPConfig(context, model, alias));
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ServiceProviderService.createServiceName(alias), (Service)service);
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        serviceBuilder.addDependency(FederationService.createServiceName(federationAlias), FederationService.class, service.getFederationService());
        ServiceProviderAddHandler.configureHandler(context, model, service);
        SPConfiguration configuration = (SPConfiguration)service.getConfiguration();
        serviceBuilder.requires(SecurityDomainService.SERVICE_NAME.append(new String[]{configuration.getSecurityDomain()}));
        serviceBuilder.install();
    }

    static SPConfiguration toSPConfig(OperationContext context, ModelNode fromModel, String alias) throws OperationFailedException {
        SPConfiguration spType = new SPConfiguration(alias);
        String url = ServiceProviderResourceDefinition.URL.resolveModelAttribute(context, fromModel).asString();
        spType.setServiceURL(url);
        String securityDomain = ServiceProviderResourceDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, fromModel).asString();
        spType.setSecurityDomain(securityDomain);
        boolean postBinding = ServiceProviderResourceDefinition.POST_BINDING.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setPostBinding(postBinding);
        boolean supportsSignatures = ServiceProviderResourceDefinition.SUPPORT_SIGNATURES.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setSupportsSignature(supportsSignatures);
        boolean supportsMetadata = ServiceProviderResourceDefinition.SUPPORT_METADATA.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setSupportMetadata(supportsMetadata);
        boolean strictPostBinding = ServiceProviderResourceDefinition.STRICT_POST_BINDING.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setIdpUsesPostBinding(strictPostBinding);
        String errorPage = ServiceProviderResourceDefinition.ERROR_PAGE.resolveModelAttribute(context, fromModel).asString();
        spType.setErrorPage(errorPage);
        String logoutPage = ServiceProviderResourceDefinition.LOGOUT_PAGE.resolveModelAttribute(context, fromModel).asString();
        spType.setLogOutPage(logoutPage);
        return spType;
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            ServiceProviderRemoveHandler.INSTANCE.performRuntime(context, operation, resource.getModel());
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }
}

