/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderAddHandler;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;

public class IdentityProviderConfigAddStepHandler
extends RestartParentResourceAddHandler {
    private final AttributeDefinition[] attributes;

    IdentityProviderConfigAddStepHandler(AttributeDefinition ... attributes) {
        super(ModelElement.IDENTITY_PROVIDER.getName());
        this.attributes = attributes != null ? attributes : new AttributeDefinition[]{};
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        IdentityProviderAddHandler.launchServices(context, parentModel, verificationHandler, null, parentAddress);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return IdentityProviderService.createServiceName(parentAddress.getLastElement().getValue());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }
}

