/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.common.parser.ModelXMLElementWriter;
import org.wildfly.extension.picketlink.federation.Namespace;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class FederationSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final Map<String, ModelXMLElementWriter> writers = new HashMap<String, ModelXMLElementWriter>();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().isDefined()) {
            return;
        }
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        List identityManagement = context.getModelNode().asList();
        for (ModelNode modelNode : identityManagement) {
            String modelName = modelNode.asProperty().getName();
            if (modelName.equals(ModelElement.FEDERATION.getName())) {
                writers.get(ModelElement.FEDERATION.getName()).write(writer, modelNode);
                continue;
            }
            PicketLinkLogger.ROOT_LOGGER.parserUnexpectedElement(modelName);
        }
        writer.writeEndElement();
    }

    private static void registerWriter(ModelElement element, ModelElement keyAttribute) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, keyAttribute.getName(), writers));
    }

    private static void registerWriter(ModelElement element) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, writers));
    }

    private static void registerWriter(ModelElement element, XMLElement parent) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, parent, writers));
    }

    private static void registerWriter(ModelElement element, ModelElement keyAttribute, XMLElement parent) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, keyAttribute.getName(), parent, writers));
    }

    static {
        FederationSubsystemWriter.registerWriter(ModelElement.FEDERATION, ModelElement.COMMON_NAME);
        FederationSubsystemWriter.registerWriter(ModelElement.IDENTITY_PROVIDER, ModelElement.COMMON_NAME);
        FederationSubsystemWriter.registerWriter(ModelElement.KEY_STORE);
        FederationSubsystemWriter.registerWriter(ModelElement.IDENTITY_PROVIDER_SAML_METADATA);
        FederationSubsystemWriter.registerWriter(ModelElement.IDENTITY_PROVIDER_SAML_METADATA_ORGANIZATION);
        FederationSubsystemWriter.registerWriter(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN, ModelElement.COMMON_NAME, XMLElement.TRUST);
        FederationSubsystemWriter.registerWriter(ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR);
        FederationSubsystemWriter.registerWriter(ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER);
        FederationSubsystemWriter.registerWriter(ModelElement.COMMON_HANDLER, XMLElement.HANDLERS);
        FederationSubsystemWriter.registerWriter(ModelElement.COMMON_HANDLER_PARAMETER, ModelElement.COMMON_NAME);
        FederationSubsystemWriter.registerWriter(ModelElement.SERVICE_PROVIDER, ModelElement.COMMON_NAME, XMLElement.SERVICE_PROVIDERS);
        FederationSubsystemWriter.registerWriter(ModelElement.SAML);
    }
}

