/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model.parser;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.idm.Namespace;
import org.wildfly.extension.picketlink.idm.model.CredentialHandlerResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.FileStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.IdentityConfigurationResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.JPAStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreAttributeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreMappingResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypesResourceDefinition;

public class IDMSubsystemReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        Namespace nameSpace = Namespace.forUri(reader.getNamespaceURI());
        ModelNode subsystemNode = this.createSubsystemRoot();
        addOperations.add(subsystemNode);
        switch (nameSpace) {
            case PICKETLINK_IDENTITY_MANAGEMENT_1_0: {
                this.readElement_1_0(reader, subsystemNode, addOperations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement_1_0(XMLExtendedStreamReader reader, ModelNode subsystemNode, List<ModelNode> addOperations) throws XMLStreamException {
        if (Namespace.PICKETLINK_IDENTITY_MANAGEMENT_1_0 != Namespace.forUri(reader.getNamespaceURI())) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        block3: while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement() || XMLElement.forName(reader.getLocalName()) != null) continue;
            ModelElement modelKey = ModelElement.forName(reader.getLocalName());
            if (modelKey == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (modelKey) {
                case PARTITION_MANAGER: {
                    this.parseIdentityManagementConfig(reader, subsystemNode, addOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentityManagementConfig(XMLExtendedStreamReader reader, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityManagementNode = this.parseConfig(reader, ModelElement.PARTITION_MANAGER, ModelElement.COMMON_NAME.getName(), parentNode, PartitionManagerResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_CONFIGURATION: {
                        IDMSubsystemReader_1_0.this.parseIdentityConfigurationConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.PARTITION_MANAGER, identityManagementNode, reader, addOperations);
    }

    private void parseIdentityConfigurationConfig(XMLExtendedStreamReader reader, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityConfigurationNode = this.parseConfig(reader, ModelElement.IDENTITY_CONFIGURATION, ModelElement.COMMON_NAME.getName(), parentNode, IdentityConfigurationResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case JPA_STORE: {
                        IDMSubsystemReader_1_0.this.parseJPAStoreConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case FILE_STORE: {
                        IDMSubsystemReader_1_0.this.parseFileStoreConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case LDAP_STORE: {
                        IDMSubsystemReader_1_0.this.parseLDAPStoreConfig(reader, addOperations, parentNode);
                    }
                }
            }
        }, ModelElement.IDENTITY_CONFIGURATION, identityConfigurationNode, reader, addOperations);
    }

    private void parseJPAStoreConfig(XMLExtendedStreamReader reader, ModelNode identityConfigurationNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode jpaStoreNode = this.parseConfig(reader, ModelElement.JPA_STORE, null, identityConfigurationNode, JPAStoreResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                        IDMSubsystemReader_1_0.this.parseCredentialHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SUPPORTED_TYPES: {
                        IDMSubsystemReader_1_0.this.parseSupportedTypesConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.JPA_STORE, jpaStoreNode, reader, addOperations);
    }

    private void parseFileStoreConfig(XMLExtendedStreamReader reader, ModelNode identityManagementNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode fileStoreNode = this.parseConfig(reader, ModelElement.FILE_STORE, null, identityManagementNode, FileStoreResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                        IDMSubsystemReader_1_0.this.parseCredentialHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SUPPORTED_TYPES: {
                        IDMSubsystemReader_1_0.this.parseSupportedTypesConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.FILE_STORE, fileStoreNode, reader, addOperations);
    }

    private void parseLDAPStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> addOperations, ModelNode identityManagementNode) throws XMLStreamException {
        ModelNode ldapStoreNode = this.parseConfig(reader, ModelElement.LDAP_STORE, null, identityManagementNode, LDAPStoreResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                        IDMSubsystemReader_1_0.this.parseCredentialHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case LDAP_STORE_MAPPING: {
                        IDMSubsystemReader_1_0.this.parseLDAPMappingConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SUPPORTED_TYPES: {
                        IDMSubsystemReader_1_0.this.parseSupportedTypesConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.LDAP_STORE, ldapStoreNode, reader, addOperations);
    }

    private void parseLDAPMappingConfig(XMLExtendedStreamReader reader, ModelNode identityProviderNode, List<ModelNode> addOperations) throws XMLStreamException {
        String name = this.resolveNodeName(reader, LDAPStoreMappingResourceDefinition.CLASS_NAME, LDAPStoreMappingResourceDefinition.CODE);
        ModelNode ldapMappingConfig = this.parseConfig(reader, ModelElement.LDAP_STORE_MAPPING, name, identityProviderNode, LDAPStoreMappingResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case LDAP_STORE_ATTRIBUTE: {
                        IDMSubsystemReader_1_0.this.parseConfig(reader, ModelElement.LDAP_STORE_ATTRIBUTE, LDAPStoreAttributeResourceDefinition.NAME.getName(), parentNode, LDAPStoreAttributeResourceDefinition.INSTANCE.getAttributes(), addOperations);
                    }
                }
            }
        }, ModelElement.LDAP_STORE_MAPPING, ldapMappingConfig, reader, addOperations);
    }

    private ModelNode parseCredentialHandlerConfig(XMLExtendedStreamReader reader, ModelNode identityProviderNode, List<ModelNode> addOperations) throws XMLStreamException {
        String name = this.resolveNodeName(reader, CredentialHandlerResourceDefinition.CLASS_NAME, CredentialHandlerResourceDefinition.CODE);
        return this.parseConfig(reader, ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER, name, identityProviderNode, CredentialHandlerResourceDefinition.INSTANCE.getAttributes(), addOperations);
    }

    private String resolveNodeName(XMLExtendedStreamReader reader, SimpleAttributeDefinition primaryAttribute, SimpleAttributeDefinition alternativeAttribute) {
        String name = reader.getAttributeValue("", primaryAttribute.getName());
        if (name == null) {
            name = reader.getAttributeValue("", alternativeAttribute.getName());
        }
        return name;
    }

    private ModelNode parseSupportedTypesConfig(XMLExtendedStreamReader reader, ModelNode identityStoreNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode supportedTypesNode = this.parseConfig(reader, ModelElement.SUPPORTED_TYPES, null, identityStoreNode, SupportedTypesResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case SUPPORTED_TYPE: {
                        String name = IDMSubsystemReader_1_0.this.resolveNodeName(reader, SupportedTypeResourceDefinition.CLASS_NAME, SupportedTypeResourceDefinition.CODE);
                        IDMSubsystemReader_1_0.this.parseConfig(reader, ModelElement.SUPPORTED_TYPE, name, parentNode, SupportedTypeResourceDefinition.INSTANCE.getAttributes(), addOperations);
                    }
                }
            }
        }, ModelElement.SUPPORTED_TYPES, supportedTypesNode, reader, addOperations);
        return supportedTypesNode;
    }

    private ModelNode createSubsystemRoot() {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "picketlink-identity-management");
        subsystemAddress.protect();
        return Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
    }

    private ModelNode parseConfig(XMLExtendedStreamReader reader, ModelElement xmlElement, String key, ModelNode lastNode, List<SimpleAttributeDefinition> attributes, List<ModelNode> addOperations) throws XMLStreamException {
        if (!reader.getLocalName().equals(xmlElement.getName())) {
            return null;
        }
        ModelNode modelNode = Util.getEmptyOperation((String)"add", null);
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            simpleAttributeDefinition.parseAndSetParameter(reader.getAttributeValue("", simpleAttributeDefinition.getXmlName()), modelNode, (XMLStreamReader)reader);
        }
        String name = xmlElement.getName();
        if (key != null) {
            name = key;
            if (modelNode.hasDefined(key)) {
                name = modelNode.get(key).asString();
            } else {
                String attributeValue = reader.getAttributeValue("", key);
                if (attributeValue != null) {
                    name = attributeValue;
                }
            }
        }
        modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), name));
        addOperations.add(modelNode);
        return modelNode;
    }

    private void parseElement(ElementParser parser, ModelElement parentElement, ModelNode parentNode, XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement()) {
                if (!reader.isEndElement() || !reader.getLocalName().equals(parentElement.getName())) continue;
                break;
            }
            if (reader.getLocalName().equals(parentElement.getName())) continue;
            ModelElement element = ModelElement.forName(reader.getLocalName());
            if (element == null) {
                if (XMLElement.forName(reader.getLocalName()) != null) continue;
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            parser.parse(reader, element, parentNode, addOperations);
        }
    }

    private static interface ElementParser {
        public void parse(XMLExtendedStreamReader var1, ModelElement var2, ModelNode var3, List<ModelNode> var4) throws XMLStreamException;
    }
}

