/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class CommonXml
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<ModelMarshallingContext> {
    protected static final Set<String> RESTRICTED_PATHS;
    private static final char[] NEW_LINE;

    protected CommonXml() {
    }

    protected void parseNamespaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null || prefix.length() <= 0) continue;
            nodes.add(NamespaceAddHandler.getAddNamespaceOperation((ModelNode)address, (String)prefix, (String)reader.getNamespaceURI(i)));
        }
    }

    protected void readHeadComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void readTailComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void parseSchemaLocations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updateList, int idx) throws XMLStreamException {
        List elements = reader.getListAttributeValue(idx);
        ArrayList<String> values = new ArrayList<String>();
        for (String element : elements) {
            if (element.trim().isEmpty()) continue;
            values.add(element);
        }
        if ((values.size() & 1) != 0) {
            throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)idx);
        }
        Iterator it = values.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)it.next();
            if (key.length() <= 0 || val.length() <= 0) continue;
            updateList.add(SchemaLocationAddHandler.getAddSchemaLocationOperation((ModelNode)address, (String)key, (String)val));
        }
    }

    protected void writeSchemaLocation(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (!modelNode.hasDefined("schema-locations")) {
            return;
        }
        StringBuilder b = new StringBuilder();
        Iterator iterator = modelNode.get("schema-locations").asList().iterator();
        while (iterator.hasNext()) {
            ModelNode location = (ModelNode)iterator.next();
            Property property = location.asProperty();
            b.append(property.getName()).append(' ').append(property.getValue().asString());
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        if (b.length() > 0) {
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.SCHEMA_LOCATION.getLocalName(), b.toString());
        }
    }

    protected void writeNamespaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        boolean needXsd = modelNode.hasDefined("schema-locations") && modelNode.get("schema-locations").asInt() > 0;
        boolean hasNamespaces = modelNode.hasDefined("namespaces");
        if (!needXsd && !hasNamespaces) {
            return;
        }
        boolean wroteXsd = false;
        String xsdUri = Namespace.XML_SCHEMA_INSTANCE.getUriString();
        if (hasNamespaces) {
            for (Property property : modelNode.get("namespaces").asPropertyList()) {
                String uri = property.getValue().asString();
                writer.writeNamespace(property.getName(), uri);
                if (wroteXsd || !xsdUri.equals(uri)) continue;
                wroteXsd = true;
            }
        }
        if (needXsd && !wroteXsd) {
            writer.writeNamespace("xsd", xsdUri);
        }
    }

    protected static void writeElement(XMLExtendedStreamWriter writer, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
    }

    protected void writePaths(XMLExtendedStreamWriter writer, ModelNode node, boolean namedPath) throws XMLStreamException {
        List paths = node.asPropertyList();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            ModelNode path = ((Property)it.next()).getValue();
            if (path.isDefined()) continue;
            it.remove();
        }
        if (paths.size() > 0) {
            writer.writeStartElement(Element.PATHS.getLocalName());
            for (ModelNode path : paths) {
                ModelNode value = path.getValue();
                writer.writeEmptyElement(Element.PATH.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), path.getName());
                if (!namedPath || value.get("path").isDefined()) {
                    writer.writeAttribute(Attribute.PATH.getLocalName(), value.get("path").asString());
                }
                if (!value.has("relative-to") || !value.get("relative-to").isDefined()) continue;
                writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), value.get("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    protected void parseFSBaseType(XMLExtendedStreamReader reader, ModelNode parent, boolean isArchive) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        content.get("archive").set(isArchive);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case PATH: {
                    content.get("path").set(value);
                    continue block4;
                }
                case RELATIVE_TO: {
                    content.get("relative-to").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void parsePaths(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requirePath) throws XMLStreamException {
        HashSet<String> pathNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            switch (element) {
                case PATH: {
                    this.parsePath(reader, address, list, requirePath, pathNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parsePath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath, Set<String> defined) throws XMLStreamException {
        String name = null;
        ModelNode path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    if (RESTRICTED_PATHS.contains(value)) {
                        throw ControllerMessages.MESSAGES.reserved(name, reader.getLocation());
                    }
                    if (defined.add(name)) continue block5;
                    throw ControllerMessages.MESSAGES.alreadyDefined(name, reader.getLocation());
                }
                case PATH: {
                    path = ParseUtils.parsePossibleExpression((String)value);
                    continue block5;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (requirePath && path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode update = new ModelNode();
        update.get("address").set(address).add("path", name);
        update.get("operation").set("add");
        if (path != null) {
            update.get("path").set(path);
        }
        if (relativeTo != null) {
            update.get("relative-to").set(relativeTo);
        }
        list.add(update);
    }

    protected void parseSystemProperties(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> updates, boolean standalone) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (element != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            boolean setName = false;
            boolean setValue = false;
            boolean setBoottime = false;
            ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)new ModelNode());
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                String val = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (setName) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"name");
                        }
                        setName = true;
                        ModelNode addr = new ModelNode().set(address).add("system-property", val);
                        op.get("address").set(addr);
                        continue block6;
                    }
                    case VALUE: {
                        if (setValue) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"value");
                        }
                        setValue = true;
                        SystemPropertyResourceDefinition.VALUE.parseAndSetParameter(val, op, (XMLStreamReader)reader);
                        continue block6;
                    }
                    case BOOT_TIME: {
                        if (standalone) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        if (setBoottime) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"boot-time");
                        }
                        setBoottime = true;
                        SystemPropertyResourceDefinition.BOOT_TIME.parseAndSetParameter(val, op, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (!setName) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            updates.add(op);
        }
    }

    protected void parseInterfaceCriteria(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode interfaceModel) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return;
        }
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        Element element = Element.forName((String)reader.getLocalName());
        switch (element) {
            case ANY_ADDRESS: 
            case ANY_IPV4_ADDRESS: 
            case ANY_IPV6_ADDRESS: {
                interfaceModel.get(element.getLocalName()).set(true);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return;
            }
        }
        do {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ANY: {
                    this.parseCompoundInterfaceCriterion(reader, expectedNs, interfaceModel.get("any").setEmptyObject());
                    break;
                }
                case NOT: {
                    this.parseCompoundInterfaceCriterion(reader, expectedNs, interfaceModel.get("not").setEmptyObject());
                    break;
                }
                default: {
                    this.parseSimpleInterfaceCriterion(reader, interfaceModel, false);
                }
            }
        } while (reader.nextTag() != 2);
    }

    protected void parseCompoundInterfaceCriterion(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode subModel) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            this.parseSimpleInterfaceCriterion(reader, subModel, true);
        }
    }

    protected void parseContentType(XMLExtendedStreamReader reader, ModelNode parent) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SHA1: {
                    try {
                        content.get("hash").set(HashUtil.hexStringToByteArray((String)value));
                        continue block5;
                    }
                    catch (Exception e) {
                        throw ControllerMessages.MESSAGES.invalidSha1Value((Throwable)e, value, attribute.getLocalName(), reader.getLocation());
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void parseSimpleInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode subModel, boolean nested) throws XMLStreamException {
        Element element = Element.forName((String)reader.getLocalName());
        String localName = element.getLocalName();
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression((String)value);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(valueNode);
                    break;
                }
                subModel.get(localName).set(valueNode);
                break;
            }
            case LOOPBACK_ADDRESS: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression((String)value);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                subModel.get(localName).set(valueNode);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                subModel.get(localName).set(true);
                break;
            }
            case NIC: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            case NIC_MATCH: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.PATTERN.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            case SUBNET_MATCH: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                this.validateAddressMask(value, reader.getLocation());
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void validateAddressMask(String value, Location location) throws XMLStreamException {
        String[] split = value.split("/");
        try {
            if (split.length != 2) {
                throw new XMLStreamException(ControllerMessages.MESSAGES.invalidAddressMaskValue(value), location);
            }
            InetAddress addr = InetAddress.getByName(split[0]);
            addr.getAddress();
            Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            throw new XMLStreamException(ControllerMessages.MESSAGES.invalidAddressMask(split[1], e.getLocalizedMessage()), location, e);
        }
        catch (UnknownHostException e) {
            throw new XMLStreamException(ControllerMessages.MESSAGES.invalidAddressValue(split[0], e.getLocalizedMessage()), location, e);
        }
    }

    protected void parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean checkSpecified) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (Element.INTERFACE != element) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw ControllerMessages.MESSAGES.duplicateInterfaceDeclaration(reader.getLocation());
            }
            ModelNode interfaceAdd = new ModelNode();
            interfaceAdd.get("address").set(address).add("interface", name);
            interfaceAdd.get("operation").set("add");
            ModelNode criteriaNode = interfaceAdd;
            this.parseInterfaceCriteria(reader, expectedNs, interfaceAdd);
            if (checkSpecified && criteriaNode.getType() != ModelType.STRING && criteriaNode.getType() != ModelType.EXPRESSION && criteriaNode.asInt() == 0) {
                throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
            }
            list.add(interfaceAdd);
        }
    }

    protected void parseSocketBindingGroupRef(XMLExtendedStreamReader reader, ModelNode addOperation, SimpleAttributeDefinition socketBindingGroup, SimpleAttributeDefinition portOffset) throws XMLStreamException {
        boolean gotRef = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case REF: {
                    socketBindingGroup.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    gotRef = true;
                    continue block4;
                }
                case PORT_OFFSET: {
                    portOffset.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!gotRef) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REF));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String name = null;
        ModelNode binding = new ModelNode();
        binding.get("address");
        binding.get("operation").set("add");
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    binding.get("address").set(address).add("socket-binding", name);
                    continue block11;
                }
                case INTERFACE: {
                    AbstractSocketBindingResourceDefinition.INTERFACE.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    if (binding.get(AbstractSocketBindingResourceDefinition.INTERFACE.getName()).getType() != ModelType.EXPRESSION && !interfaces.contains(value)) {
                        throw ControllerMessages.MESSAGES.unknownInterface(value, attribute.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    binding.get("interface").set(value);
                    continue block11;
                }
                case PORT: {
                    AbstractSocketBindingResourceDefinition.PORT.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                case FIXED_PORT: {
                    AbstractSocketBindingResourceDefinition.FIXED_PORT.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                case MULTICAST_ADDRESS: {
                    AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                case MULTICAST_PORT: {
                    AbstractSocketBindingResourceDefinition.MULTICAST_PORT.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case CLIENT_MAPPING: {
                    binding.get("client-mappings").add(this.parseClientMapping(reader));
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(binding);
        return name;
    }

    private ModelNode parseClientMapping(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode mapping = new ModelNode();
        boolean hasDestinationAddress = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOURCE_NETWORK: {
                    AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_SOURCE_NETWORK.parseAndSetParameter(value, mapping, (XMLStreamReader)reader);
                    continue block5;
                }
                case DESTINATION_ADDRESS: {
                    AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_ADDRESS.parseAndSetParameter(value, mapping, (XMLStreamReader)reader);
                    hasDestinationAddress = true;
                    continue block5;
                }
                case DESTINATION_PORT: {
                    AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_PORT.parseAndSetParameter(value, mapping, (XMLStreamReader)reader);
                }
            }
        }
        if (!hasDestinationAddress) {
            throw ControllerMessages.MESSAGES.missingRequiredAttributes(new StringBuilder("destination-address"), reader.getLocation());
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return mapping;
    }

    protected String parseOutboundSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String outboundSocketBindingName = null;
        ModelNode outboundSocketBindingAddOperation = new ModelNode();
        outboundSocketBindingAddOperation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    outboundSocketBindingName = value;
                    continue block10;
                }
                case SOURCE_INTERFACE: {
                    OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    if (interfaces.contains(value) || outboundSocketBindingAddOperation.get(OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.getName()).getType() == ModelType.EXPRESSION) continue block10;
                    throw ControllerMessages.MESSAGES.unknownValueForElement(Attribute.SOURCE_INTERFACE.getLocalName(), value, Element.INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                }
                case SOURCE_PORT: {
                    OutboundSocketBindingResourceDefinition.SOURCE_PORT.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case FIXED_SOURCE_PORT: {
                    OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean mutuallyExclusiveElementAlreadyFound = false;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName((String)reader.getLocalName())) {
                case LOCAL_DESTINATION: {
                    if (mutuallyExclusiveElementAlreadyFound) {
                        throw ControllerMessages.MESSAGES.invalidOutboundSocketBinding(outboundSocketBindingName, Element.LOCAL_DESTINATION.getLocalName(), Element.REMOTE_DESTINATION.getLocalName(), reader.getLocation());
                    }
                    mutuallyExclusiveElementAlreadyFound = true;
                    this.parseLocalDestinationOutboundSocketBinding(reader, outboundSocketBindingAddOperation);
                    ModelNode addr = address.clone().add("local-destination-outbound-socket-binding", outboundSocketBindingName);
                    outboundSocketBindingAddOperation.get("address").set(addr);
                    continue block11;
                }
                case REMOTE_DESTINATION: {
                    if (mutuallyExclusiveElementAlreadyFound) {
                        throw ControllerMessages.MESSAGES.invalidOutboundSocketBinding(outboundSocketBindingName, Element.LOCAL_DESTINATION.getLocalName(), Element.REMOTE_DESTINATION.getLocalName(), reader.getLocation());
                    }
                    mutuallyExclusiveElementAlreadyFound = true;
                    this.parseRemoteDestinationOutboundSocketBinding(reader, outboundSocketBindingAddOperation);
                    ModelNode addr = address.clone().add("remote-destination-outbound-socket-binding", outboundSocketBindingName);
                    outboundSocketBindingAddOperation.get("address").set(addr);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(outboundSocketBindingAddOperation);
        return outboundSocketBindingName;
    }

    private void parseLocalDestinationOutboundSocketBinding(XMLExtendedStreamReader reader, ModelNode outboundSocketBindingAddOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case SOCKET_BINDING_REF: {
                    LocalDestinationOutboundSocketBindingResourceDefinition.SOCKET_BINDING_REF.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRemoteDestinationOutboundSocketBinding(XMLExtendedStreamReader reader, ModelNode outboundSocketBindingAddOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.HOST, Attribute.PORT);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case HOST: {
                    RemoteDestinationOutboundSocketBindingResourceDefinition.HOST.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case PORT: {
                    RemoteDestinationOutboundSocketBindingResourceDefinition.PORT.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void parseDeployments(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Set<Attribute> allowedAttributes, Set<Element> allowedElements) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        HashSet<String> runtimeNames = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element deployment = Element.forName((String)reader.getLocalName());
            if (Element.DEPLOYMENT != deployment) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode deploymentAdd = Util.getEmptyOperation((String)"add", null);
            String uniqueName = null;
            EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME);
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                if (!allowedAttributes.contains(attribute)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                requiredAttributes.remove(attribute);
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        uniqueName = value;
                        continue block11;
                    }
                    case RUNTIME_NAME: {
                        if (!runtimeNames.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        DeploymentAttributes.RUNTIME_NAME.parseAndSetParameter(value, deploymentAdd, (XMLStreamReader)reader);
                        continue block11;
                    }
                    case ENABLED: {
                        DeploymentAttributes.ENABLED.parseAndSetParameter(value, deploymentAdd, (XMLStreamReader)reader);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (requiredAttributes.size() > 0) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
            }
            ModelNode deploymentAddress = address.clone().add("deployment", uniqueName);
            deploymentAdd.get("address").set(deploymentAddress);
            if (allowedAttributes.contains(Attribute.ENABLED) && !deploymentAdd.hasDefined(DeploymentAttributes.ENABLED.getName())) {
                deploymentAdd.get(DeploymentAttributes.ENABLED.getName()).set(true);
            }
            block12: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                if (!allowedElements.contains(element)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                switch (element) {
                    case CONTENT: {
                        this.parseContentType(reader, deploymentAdd);
                        continue block12;
                    }
                    case FS_ARCHIVE: {
                        this.parseFSBaseType(reader, deploymentAdd, true);
                        continue block12;
                    }
                    case FS_EXPLODED: {
                        this.parseFSBaseType(reader, deploymentAdd, false);
                        continue block12;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(deploymentAdd);
        }
    }

    protected void parseDeploymentOverlays(XMLExtendedStreamReader reader, Namespace namespace, ModelNode baseAddress, List<ModelNode> list, boolean allowContent, boolean allowDeployment) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case DEPLOYMENT_OVERLAY: {
                    this.parseDeploymentOverlay(reader, baseAddress, list, allowContent, allowDeployment);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseDeploymentOverlay(XMLExtendedStreamReader reader, ModelNode baseAddress, List<ModelNode> list, boolean allowContent, boolean allowDeployment) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode addr = baseAddress.clone();
        addr.add("deployment-overlay", name);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(addr);
        list.add(op);
        while (reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            if (element == Element.CONTENT && allowContent) {
                this.parseContentOverride(name, reader, baseAddress, list);
                continue;
            }
            if (element == Element.DEPLOYMENT && allowDeployment) {
                this.parseDeploymentOverlayDeployment(name, reader, baseAddress, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseContentOverride(String name, XMLExtendedStreamReader reader, ModelNode baseAddress, List<ModelNode> list) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.CONTENT);
        String path = null;
        byte[] content = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block4;
                }
                case CONTENT: {
                    content = HashUtil.hexStringToByteArray((String)value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode address = baseAddress.clone();
        address.add("deployment-overlay", name);
        address.add("content", path);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(address);
        op.get("content").get("hash").set(content);
        list.add(op);
    }

    protected void parseDeploymentOverlayDeployment(String name, XMLExtendedStreamReader reader, ModelNode baseAddress, List<ModelNode> list) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String depName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    depName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode address = baseAddress.clone();
        address.add("deployment-overlay", name);
        address.add("deployment", depName);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(address);
        list.add(op);
    }

    protected void parseVault(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        int vaultAttribCount = reader.getAttributeCount();
        ModelNode vault = new ModelNode();
        String code = null;
        if (vaultAttribCount > 1) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)vaultAttribCount);
        }
        block6: for (int i = 0; i < vaultAttribCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    code = value;
                    vault.get(Attribute.CODE.getLocalName()).set(code);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode vaultAddress = address.clone();
        vaultAddress.add("core-service", "vault");
        if (code != null) {
            vault.get(Attribute.CODE.getLocalName()).set(code);
        }
        vault.get("address").set(vaultAddress);
        vault.get("operation").set("add");
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    this.parseModuleOption(reader, vault.get("vault-options"));
                }
            }
        }
        list.add(vault);
    }

    protected void parseVaultOption(XMLExtendedStreamReader reader, ModelNode vaultOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        vaultOptions.get(name).set(val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void parseModuleOption(XMLExtendedStreamReader reader, ModelNode moduleOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        moduleOptions.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void writeInterfaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.INTERFACES.getLocalName());
        Set interfaces = modelNode.keys();
        for (String ifaceName : interfaces) {
            ModelNode iface = modelNode.get(ifaceName);
            writer.writeStartElement(Element.INTERFACE.getLocalName());
            CommonXml.writeAttribute(writer, Attribute.NAME, ifaceName);
            if (iface.get(Element.ANY_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_ADDRESS.getLocalName());
            } else if (iface.get(Element.ANY_IPV4_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_IPV4_ADDRESS.getLocalName());
            } else if (iface.get(Element.ANY_IPV6_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_IPV6_ADDRESS.getLocalName());
            } else {
                this.writeInterfaceCriteria(writer, iface, false);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode subModel, boolean nested) throws XMLStreamException {
        for (Property property : subModel.asPropertyList()) {
            if (!property.getValue().isDefined()) continue;
            this.writeInterfaceCriteria(writer, property, nested);
        }
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, Property property, boolean nested) throws XMLStreamException {
        Element element = Element.forName((String)property.getName());
        switch (element) {
            case INET_ADDRESS: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), nested);
                break;
            }
            case LOOPBACK_ADDRESS: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), false);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                if (!property.getValue().asBoolean(false)) break;
                writer.writeEmptyElement(element.getLocalName());
                break;
            }
            case NIC: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.NAME, property.getValue(), nested);
                break;
            }
            case NIC_MATCH: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.PATTERN, property.getValue(), nested);
                break;
            }
            case SUBNET_MATCH: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), nested);
                break;
            }
            case ANY: 
            case NOT: {
                if (nested) break;
                writer.writeStartElement(element.getLocalName());
                this.writeInterfaceCriteria(writer, property.getValue(), true);
                writer.writeEndElement();
                break;
            }
            case NAME: {
                break;
            }
            default: {
                throw ControllerMessages.MESSAGES.unknownCriteriaInterfaceProperty(property.getName());
            }
        }
    }

    private static void writeInterfaceCriteria(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel, boolean asList) throws XMLStreamException {
        if (asList) {
            CommonXml.writeListAsMultipleElements(writer, element, attribute, subModel);
        } else {
            CommonXml.writeSingleElement(writer, element, attribute, subModel);
        }
    }

    private static void writeSingleElement(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel) throws XMLStreamException {
        writer.writeEmptyElement(element.getLocalName());
        CommonXml.writeAttribute(writer, attribute, subModel.asString());
    }

    private static void writeListAsMultipleElements(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel) throws XMLStreamException {
        List list = subModel.asList();
        for (ModelNode node : list) {
            writer.writeEmptyElement(element.getLocalName());
            CommonXml.writeAttribute(writer, attribute, node.asString());
        }
    }

    protected void writeSocketBindingGroup(XMLExtendedStreamWriter writer, ModelNode bindingGroup, boolean fromServer) throws XMLStreamException {
        ModelNode outboundSocketBinding;
        writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
        SocketBindingGroupResourceDefinition.NAME.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        if (fromServer) {
            SocketBindingGroupResourceDefinition.PORT_OFFSET.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        }
        if (!fromServer) {
            SocketBindingGroupResourceDefinition.INCLUDES.marshallAsElement(bindingGroup, (XMLStreamWriter)writer);
        }
        if (bindingGroup.hasDefined("socket-binding")) {
            ModelNode bindings = bindingGroup.get("socket-binding");
            for (String bindingName : bindings.keys()) {
                ModelNode binding = bindings.get(bindingName);
                writer.writeStartElement(Element.SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, bindingName);
                AbstractSocketBindingResourceDefinition.INTERFACE.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.PORT.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.FIXED_PORT.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.MULTICAST_PORT.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                ModelNode attr = binding.get("client-mappings");
                if (attr.isDefined()) {
                    for (ModelNode mapping : attr.asList()) {
                        writer.writeEmptyElement(Element.CLIENT_MAPPING.getLocalName());
                        AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_SOURCE_NETWORK.marshallAsAttribute(mapping, (XMLStreamWriter)writer);
                        AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_ADDRESS.marshallAsAttribute(mapping, (XMLStreamWriter)writer);
                        AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_PORT.marshallAsAttribute(mapping, (XMLStreamWriter)writer);
                    }
                }
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("local-destination-outbound-socket-binding")) {
            ModelNode localDestinationOutboundSocketBindings = bindingGroup.get("local-destination-outbound-socket-binding");
            for (String outboundSocketBindingName : localDestinationOutboundSocketBindings.keys()) {
                outboundSocketBinding = localDestinationOutboundSocketBindings.get(outboundSocketBindingName);
                writer.writeStartElement(Element.OUTBOUND_SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, outboundSocketBindingName);
                OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEmptyElement(Element.LOCAL_DESTINATION.getLocalName());
                LocalDestinationOutboundSocketBindingResourceDefinition.SOCKET_BINDING_REF.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("remote-destination-outbound-socket-binding")) {
            ModelNode remoteDestinationOutboundSocketBindings = bindingGroup.get("remote-destination-outbound-socket-binding");
            for (String outboundSocketBindingName : remoteDestinationOutboundSocketBindings.keys()) {
                outboundSocketBinding = remoteDestinationOutboundSocketBindings.get(outboundSocketBindingName);
                writer.writeStartElement(Element.OUTBOUND_SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, outboundSocketBindingName);
                OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEmptyElement(Element.REMOTE_DESTINATION.getLocalName());
                RemoteDestinationOutboundSocketBindingResourceDefinition.HOST.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                RemoteDestinationOutboundSocketBindingResourceDefinition.PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void writeProperties(XMLExtendedStreamWriter writer, ModelNode modelNode, Element element, boolean standalone) throws XMLStreamException {
        List properties = modelNode.asPropertyList();
        if (properties.size() > 0) {
            writer.writeStartElement(element.getLocalName());
            for (Property prop : properties) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, prop.getName());
                ModelNode sysProp = prop.getValue();
                SystemPropertyResourceDefinition.VALUE.marshallAsAttribute(sysProp, (XMLStreamWriter)writer);
                if (!standalone) {
                    SystemPropertyResourceDefinition.BOOT_TIME.marshallAsAttribute(sysProp, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    protected static void writeContentItem(XMLExtendedStreamWriter writer, ModelNode contentItem) throws XMLStreamException {
        if (contentItem.has("hash")) {
            CommonXml.writeElement(writer, Element.CONTENT);
            CommonXml.writeAttribute(writer, Attribute.SHA1, HashUtil.bytesToHexString((byte[])contentItem.require("hash").asBytes()));
            writer.writeEndElement();
        } else {
            if (contentItem.require("archive").asBoolean()) {
                CommonXml.writeElement(writer, Element.FS_ARCHIVE);
            } else {
                CommonXml.writeElement(writer, Element.FS_EXPLODED);
            }
            CommonXml.writeAttribute(writer, Attribute.PATH, contentItem.require("path").asString());
            if (contentItem.has("relative-to")) {
                CommonXml.writeAttribute(writer, Attribute.RELATIVE_TO, contentItem.require("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    protected void writeVault(XMLExtendedStreamWriter writer, ModelNode vault) throws XMLStreamException {
        String code;
        writer.writeStartElement(Element.VAULT.getLocalName());
        String string = code = vault.hasDefined(Attribute.CODE.getLocalName()) ? vault.get(Attribute.CODE.getLocalName()).asString() : null;
        if (code != null && !code.isEmpty()) {
            writer.writeAttribute(Attribute.CODE.getLocalName(), code);
        }
        if (vault.hasDefined("vault-options")) {
            ModelNode properties = vault.get("vault-options");
            for (Property prop : properties.asPropertyList()) {
                writer.writeEmptyElement(Element.VAULT_OPTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
            }
        }
        writer.writeEndElement();
    }

    protected static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(NEW_LINE, 0, 1);
    }

    protected void writeDeploymentOverlays(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set names = modelNode.keys();
        if (names.size() > 0) {
            writer.writeStartElement(Element.DEPLOYMENT_OVERLAYS.getLocalName());
            for (String uniqueName : names) {
                ModelNode deployments;
                Set deploymentNames;
                ModelNode contentItem = modelNode.get(uniqueName);
                writer.writeStartElement(Element.DEPLOYMENT_OVERLAY.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, uniqueName);
                if (contentItem.hasDefined("content")) {
                    ModelNode overridesNode = contentItem.get("content");
                    Set overrides = overridesNode.keys();
                    for (String override : overrides) {
                        ModelNode overrideNode = overridesNode.get(override);
                        String content = HashUtil.bytesToHexString((byte[])overrideNode.require("content").asBytes());
                        writer.writeStartElement(Element.CONTENT.getLocalName());
                        CommonXml.writeAttribute(writer, Attribute.PATH, override);
                        CommonXml.writeAttribute(writer, Attribute.CONTENT, content);
                        writer.writeEndElement();
                    }
                }
                if (contentItem.hasDefined("deployment") && (deploymentNames = (deployments = contentItem.get("deployment")).keys()).size() > 0) {
                    for (String deploymentName : deploymentNames) {
                        ModelNode depNode = deployments.get(deploymentName);
                        writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                        CommonXml.writeAttribute(writer, Attribute.NAME, deploymentName);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            CommonXml.writeNewLine(writer);
        }
    }

    static {
        HashSet<String> set = new HashSet<String>(10);
        set.add("jboss.home");
        set.add("jboss.home.dir");
        set.add("user.home");
        set.add("user.dir");
        set.add("java.home");
        set.add("jboss.server.base.dir");
        set.add("jboss.server.data.dir");
        set.add("jboss.server.log.dir");
        set.add("jboss.server.temp.dir");
        set.add("jboss.modules.dir");
        set.add("jboss.server.deploy.dir");
        set.add("jboss.domain.servers.dir");
        RESTRICTED_PATHS = Collections.unmodifiableSet(set);
        NEW_LINE = new char[]{'\n'};
    }
}

