/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.subsystem.CMResourceResourceDefinition;
import org.jboss.as.txn.subsystem.LogStoreDefinition;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.LogStoreTransactionDefinition;
import org.jboss.as.txn.subsystem.LogStoreTransactionParticipantDefinition;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystem10Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem11Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem12Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem13Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem14Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem15Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem20Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem30Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.as.txn.subsystem.TransactionSubsystemXMLPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class TransactionExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "transactions";
    public static final String RESOLVE_OBJECT_STORE_PATH = "resolve-object-store-path";
    private static final String RESOURCE_NAME = TransactionExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    private static final ServiceName MBEAN_SERVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    static final PathElement LOG_STORE_PATH = PathElement.pathElement((String)"log-store", (String)"log-store");
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"transactions");
    static final PathElement PARTICIPANT_PATH = PathElement.pathElement((String)"participants");
    static final PathElement TRANSACTION_PATH = PathElement.pathElement((String)"transactions");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, TransactionExtension.class.getClassLoader(), true, false);
    }

    static MBeanServer getMBeanServer(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController serviceController = serviceRegistry.getService(MBEAN_SERVER_SERVICE_NAME);
        if (serviceController == null) {
            throw TransactionLogger.ROOT_LOGGER.jmxSubsystemNotInstalled();
        }
        return (MBeanServer)serviceController.getValue();
    }

    public void initialize(ExtensionContext context) {
        TransactionLogger.ROOT_LOGGER.debug("Initializing Transactions Extension");
        LogStoreResource resource = new LogStoreResource();
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        TransactionSubsystemRootResourceDefinition rootResourceDefinition = new TransactionSubsystemRootResourceDefinition(registerRuntimeOnly);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)rootResourceDefinition);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (context.getProcessType().isServer()) {
            ResolvePathHandler objectStorePathHandler = ResolvePathHandler.Builder.of((String)RESOLVE_OBJECT_STORE_PATH, (PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH).setRelativeToAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO).build();
            registration.registerOperationHandler(objectStorePathHandler.getOperationDefinition(), (OperationStepHandler)objectStorePathHandler);
        }
        ManagementResourceRegistration logStoreChild = registration.registerSubModel((ResourceDefinition)new LogStoreDefinition(resource, registerRuntimeOnly));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration transactionChild = logStoreChild.registerSubModel((ResourceDefinition)new LogStoreTransactionDefinition(resource));
            transactionChild.registerSubModel((ResourceDefinition)LogStoreTransactionParticipantDefinition.INSTANCE);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)TransactionSubsystemXMLPersister.INSTANCE);
        if (context.isRegisterTransformers()) {
            TransactionExtension.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_0.getUriString(), (XMLElementReader)TransactionSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_1.getUriString(), (XMLElementReader)TransactionSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_2.getUriString(), (XMLElementReader)TransactionSubsystem12Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_3.getUriString(), (XMLElementReader)TransactionSubsystem13Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_4.getUriString(), (XMLElementReader)TransactionSubsystem14Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_5.getUriString(), (XMLElementReader)TransactionSubsystem15Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_2_0.getUriString(), (XMLElementReader)TransactionSubsystem20Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_3_0.getUriString(), (XMLElementReader)TransactionSubsystem30Parser.INSTANCE);
    }

    private static void registerTransformers(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder subsystemRoot200 = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        subsystemRoot200.rejectChildResource(CMResourceResourceDefinition.PATH_CM_RESOURCE);
        ModelVersion version200 = ModelVersion.create((int)2, (int)0, (int)0);
        TransformationDescription description200 = subsystemRoot200.build();
        TransformationDescription.Tools.register((TransformationDescription)description200, (SubsystemRegistration)subsystem, (ModelVersionRange)version200);
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{TransactionSubsystemRootResourceDefinition.HORNETQ_STORE_ENABLE_ASYNC_IO})).addRejectCheck((RejectAttributeChecker)RejectHornetQStoreAsyncIOChecker.INSTANCE, new AttributeDefinition[]{TransactionSubsystemRootResourceDefinition.HORNETQ_STORE_ENABLE_ASYNC_IO})).addRename((AttributeDefinition)TransactionSubsystemRootResourceDefinition.STATISTICS_ENABLED, "enable-statistics")).setValueConverter((AttributeConverter)ProcessIdUuidConverter.INSTANCE, new AttributeDefinition[]{TransactionSubsystemRootResourceDefinition.PROCESS_ID_UUID});
        subsystemRoot.rejectChildResource(CMResourceResourceDefinition.PATH_CM_RESOURCE);
        ModelVersion version120 = ModelVersion.create((int)1, (int)2, (int)0);
        TransformationDescription description120 = subsystemRoot.build();
        TransformationDescription.Tools.register((TransformationDescription)description120, (SubsystemRegistration)subsystem, (ModelVersionRange)version120);
        ((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().setDiscard((DiscardAttributeChecker)UnneededJDBCStoreChecker.INSTANCE, TransactionSubsystemRootResourceDefinition.attributes_1_2)).addRejectCheck(RejectAttributeChecker.DEFINED, TransactionSubsystemRootResourceDefinition.attributes_1_2);
        subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, TransactionSubsystemRootResourceDefinition.ATTRIBUTES_WITH_EXPRESSIONS_AFTER_1_1_1);
        subsystemRoot.rejectChildResource(CMResourceResourceDefinition.PATH_CM_RESOURCE);
        ModelVersion version111 = ModelVersion.create((int)1, (int)1, (int)1);
        TransformationDescription description111 = subsystemRoot.build();
        TransformationDescription.Tools.register((TransformationDescription)description111, (SubsystemRegistration)subsystem, (ModelVersionRange)version111);
        ModelVersion version110 = ModelVersion.create((int)1, (int)1, (int)0);
        subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, TransactionSubsystemRootResourceDefinition.ATTRIBUTES_WITH_EXPRESSIONS_AFTER_1_1_0);
        TransformationDescription description110 = subsystemRoot.build();
        TransformationDescription.Tools.register((TransformationDescription)description110, (SubsystemRegistration)subsystem, (ModelVersionRange)version110);
    }

    private static class ProcessIdUuidConverter
    extends AttributeConverter.DefaultAttributeConverter {
        static final ProcessIdUuidConverter INSTANCE = new ProcessIdUuidConverter();

        private ProcessIdUuidConverter() {
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (!attributeValue.isDefined()) {
                attributeValue.set(false);
            }
        }
    }

    private static class RejectHornetQStoreAsyncIOChecker
    extends RejectAttributeChecker.DefaultRejectAttributeChecker {
        static final RejectHornetQStoreAsyncIOChecker INSTANCE = new RejectHornetQStoreAsyncIOChecker();

        private RejectHornetQStoreAsyncIOChecker() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return TransactionLogger.ROOT_LOGGER.transformHornetQStoreEnableAsyncIoMustBeTrue();
        }

        public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            if (operation.get("operation").asString().equals("add")) {
                return this.rejectCheck(address, attributeName, attributeValue, operation);
            }
            return this.rejectResourceAttribute(address, attributeName, attributeValue, context);
        }

        public boolean rejectResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return this.rejectCheck(address, attributeName, attributeValue, context.readResourceFromRoot(address).getModel());
        }

        protected boolean rejectCheck(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode model) {
            if (!(attributeValue.isDefined() && attributeValue.asString().equals("true") || !model.hasDefined(TransactionSubsystemRootResourceDefinition.USEHORNETQSTORE.getName()))) {
                return !model.get(TransactionSubsystemRootResourceDefinition.USEHORNETQSTORE.getName()).asString().equals("false");
            }
            return false;
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return false;
        }
    }

    private static class UnneededJDBCStoreChecker
    implements DiscardAttributeChecker {
        static final UnneededJDBCStoreChecker INSTANCE = new UnneededJDBCStoreChecker();

        private UnneededJDBCStoreChecker() {
        }

        public boolean isDiscardExpressions() {
            return false;
        }

        public boolean isDiscardUndefined() {
            return true;
        }

        public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            String op = operation.get("operation").asString();
            if ("write-attribute".equals(op)) {
                if (attributeName.equals(TransactionSubsystemRootResourceDefinition.USE_JDBC_STORE.getName())) {
                    return false;
                }
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                model.get(attributeName).set(attributeValue);
                return this.discard(model);
            }
            return this.discard(operation);
        }

        public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return this.discard(context.readResource(PathAddress.EMPTY_ADDRESS).getModel());
        }

        boolean discard(ModelNode model) {
            if (model.hasDefined(TransactionSubsystemRootResourceDefinition.USE_JDBC_STORE.getName())) {
                return !model.get(TransactionSubsystemRootResourceDefinition.USE_JDBC_STORE.getName()).asBoolean(true);
            }
            return true;
        }
    }
}

