/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.subsystem.LogStoreConstants;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.TransactionExtension;
import org.jboss.dmr.ModelNode;

public class LogStoreParticipantRefreshHandler
implements OperationStepHandler {
    static final LogStoreParticipantRefreshHandler INSTANCE = new LogStoreParticipantRefreshHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        MBeanServer mbs = TransactionExtension.getMBeanServer(context);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        try {
            ObjectName on = LogStoreResource.getObjectName(resource);
            ModelNode model = resource.getModel().clone();
            AttributeList attributes = mbs.getAttributes(on, LogStoreConstants.PARTICIPANT_JMX_NAMES);
            for (Attribute attribute : attributes.asList()) {
                String modelName = LogStoreConstants.jmxNameToModelName(LogStoreConstants.MODEL_TO_JMX_PARTICIPANT_NAMES, attribute.getName());
                if (modelName == null) continue;
                ModelNode aNode = model.get(modelName);
                Object value = attribute.getValue();
                if (aNode == null) continue;
                aNode.set(value == null ? "" : value.toString());
            }
            resource.writeModel(model);
        }
        catch (Exception e) {
            throw TransactionLogger.ROOT_LOGGER.jmxError(e.getMessage());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

