/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.logging;

import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.resources.spi.ClassFileInfoException;

public class WeldLogger_$logger
extends DelegatingBasicLogger
implements WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public WeldLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void failedToSetupWeldContexts(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.failedToSetupWeldContexts$str(), new Object[0]);
    }

    protected String failedToSetupWeldContexts$str() {
        return "WFLYWELD0001: Failed to setup Weld contexts";
    }

    @Override
    public final void failedToTearDownWeldContexts(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.failedToTearDownWeldContexts$str(), new Object[0]);
    }

    protected String failedToTearDownWeldContexts$str() {
        return "WFLYWELD0002: Failed to tear down Weld contexts";
    }

    @Override
    public final void processingWeldDeployment(String deployment) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.processingWeldDeployment$str(), (Object)deployment);
    }

    protected String processingWeldDeployment$str() {
        return "WFLYWELD0003: Processing weld deployment %s";
    }

    @Override
    public final void couldNotFindBeanManagerForDeployment(String beanManager) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.couldNotFindBeanManagerForDeployment$str(), (Object)beanManager);
    }

    protected String couldNotFindBeanManagerForDeployment$str() {
        return "WFLYWELD0005: Could not find BeanManager for deployment %s";
    }

    @Override
    public final void startingServicesForCDIDeployment(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingServicesForCDIDeployment$str(), (Object)deploymentName);
    }

    protected String startingServicesForCDIDeployment$str() {
        return "WFLYWELD0006: Starting Services for Jakarta Contexts and Dependency Injection deployment: %s";
    }

    @Override
    public final void couldNotLoadPortableExceptionClass(String className, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.couldNotLoadPortableExceptionClass$str(), (Object)className);
    }

    protected String couldNotLoadPortableExceptionClass$str() {
        return "WFLYWELD0007: Could not load portable extension class %s";
    }

    @Override
    public final void injectionTypeNotValue(String type, Member injectionPoint) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.injectionTypeNotValue$str(), (Object)type, (Object)injectionPoint);
    }

    protected String injectionTypeNotValue$str() {
        return "WFLYWELD0008: @Resource injection of type %s is not supported for non-Jakarta Enterprise Beans components. Injection point: %s";
    }

    @Override
    public final void startingWeldService(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingWeldService$str(), (Object)deploymentName);
    }

    protected String startingWeldService$str() {
        return "WFLYWELD0009: Starting weld service for deployment %s";
    }

    @Override
    public final void stoppingWeldService(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingWeldService$str(), (Object)deploymentName);
    }

    protected String stoppingWeldService$str() {
        return "WFLYWELD0010: Stopping weld service for deployment %s";
    }

    @Override
    public final void beansXmlValidationWarning(URL file, int line, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.beansXmlValidationWarning$str(), (Object)file, (Object)line, (Object)message);
    }

    protected String beansXmlValidationWarning$str() {
        return "WFLYWELD0011: Warning while parsing %s:%s %s";
    }

    @Override
    public final void beansXmlValidationError(URL file, int line, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.beansXmlValidationError$str(), (Object)file, (Object)line, (Object)message);
    }

    protected String beansXmlValidationError$str() {
        return "WFLYWELD0012: Warning while parsing %s:%s %s";
    }

    @Override
    public final void cdiAnnotationsButNotBeanArchive(String deploymentUnit) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cdiAnnotationsButNotBeanArchive$str(), (Object)deploymentUnit);
    }

    protected String cdiAnnotationsButNotBeanArchive$str() {
        return "WFLYWELD0013: Deployment %s contains Jakarta Contexts and Dependency Injection annotations but no bean archive was found (no beans.xml or class with bean defining annotations was present).";
    }

    @Override
    public final void exceptionClearingThreadState(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionClearingThreadState$str(), new Object[0]);
    }

    protected String exceptionClearingThreadState$str() {
        return "WFLYWELD0014: Exception tearing down thread state";
    }

    @Override
    public final void couldNotReadEntries(IOException ioe) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ioe, this.couldNotReadEntries$str(), new Object[0]);
    }

    protected String couldNotReadEntries$str() {
        return "WFLYWELD0016: Could not read entries";
    }

    @Override
    public final void doNotUnderstandProtocol(URL url) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.doNotUnderstandProtocol$str(), (Object)url);
    }

    protected String doNotUnderstandProtocol$str() {
        return "WFLYWELD0017: URL scanner does not understand the URL protocol %s, Jakarta Contexts and Dependency Injection beans will not be scanned.";
    }

    @Override
    public final void duplicateBeansXml() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateBeansXml$str(), new Object[0]);
    }

    protected String duplicateBeansXml$str() {
        return "WFLYWELD0018: Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use the former location for this deployment.";
    }

    protected String couldNotGetBeansXmlAsURL$str() {
        return "WFLYWELD0019: Could get beans.xml file as URL when processing file: %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotGetBeansXmlAsURL(String beansXml, Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotGetBeansXmlAsURL$str(), beansXml), cause);
        WeldLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String couldNotLoadInterceptorClass$str() {
        return "WFLYWELD0020: Could not load interceptor class : %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotLoadInterceptorClass(String interceptorClass, Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotLoadInterceptorClass$str(), interceptorClass), cause);
        WeldLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String extensionDoesNotImplementExtension$str() {
        return "WFLYWELD0021: Service %s didn't implement the jakarta.enterprise.inject.spi.Extension interface";
    }

    @Override
    public final DeploymentUnitProcessingException extensionDoesNotImplementExtension(Class<?> clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.extensionDoesNotImplementExtension$str(), clazz));
        WeldLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String viewNotFoundOnEJB$str() {
        return "WFLYWELD0022: View of type %s not found on Jakarta Enterprise Beans %s";
    }

    @Override
    public final IllegalArgumentException viewNotFoundOnEJB(String viewType, String ejb) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.viewNotFoundOnEJB$str(), viewType, ejb));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownInterceptorClassForCDIInjection$str() {
        return "WFLYWELD0030: Unknown interceptor class for Jakarta Contexts and Dependency Injection %s";
    }

    @Override
    public final IllegalArgumentException unknownInterceptorClassForCDIInjection(Class<?> interceptorClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownInterceptorClassForCDIInjection$str(), interceptorClass));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parameterCannotBeNull$str() {
        return "WFLYWELD0031: %s cannot be null";
    }

    @Override
    public final IllegalArgumentException parameterCannotBeNull(String param) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterCannotBeNull$str(), param));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String injectionPointNotAJavabean$str() {
        return "WFLYWELD0032: Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) %s";
    }

    @Override
    public final IllegalArgumentException injectionPointNotAJavabean(Method method) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.injectionPointNotAJavabean$str(), method));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String annotationNotFound$str() {
        return "WFLYWELD0033: %s annotation not found on %s";
    }

    @Override
    public final IllegalArgumentException annotationNotFound(Class<? extends Annotation> type, Member member) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.annotationNotFound$str(), type, member));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ejbNotResolved$str() {
        return "WFLYWELD0034: Could not resolve @EJB injection for %s on %s";
    }

    @Override
    public final IllegalStateException ejbNotResolved(Object ejb, Member member) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ejbNotResolved$str(), ejb, member));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moreThanOneEjbResolved$str() {
        return "WFLYWELD0035: Resolved more than one Jakarta Enterprise Beans for @EJB injection of %s on %s. Found %s";
    }

    @Override
    public final IllegalStateException moreThanOneEjbResolved(Object ejb, Member member, Set<ViewDescription> viewService) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.moreThanOneEjbResolved$str(), ejb, member, viewService));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotDetermineUnderlyingType$str() {
        return "WFLYWELD0036: Could not determine bean class from injection point type of %s";
    }

    @Override
    public final IllegalArgumentException couldNotDetermineUnderlyingType(Type type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotDetermineUnderlyingType$str(), type));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindPersistenceUnit$str() {
        return "WFLYWELD0037: Error injecting persistence unit into Jakarta Contexts and Dependency Injection managed bean. Can't find a persistence unit named '%s' in deployment %s for injection point %s";
    }

    @Override
    public final IllegalArgumentException couldNotFindPersistenceUnit(String unitName, String deployment, Member injectionPoint) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindPersistenceUnit$str(), unitName, deployment, injectionPoint));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityNotEnabled$str() {
        return "WFLYWELD0038: Could not inject SecurityManager, security is not enabled";
    }

    @Override
    public final IllegalStateException securityNotEnabled() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.securityNotEnabled$str(), new Object[0]));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String singletonNotSet$str() {
        return "WFLYWELD0039: Singleton not set for %s. This means that you are trying to access a weld deployment with a Thread Context ClassLoader that is not associated with the deployment.";
    }

    @Override
    public final IllegalStateException singletonNotSet(ClassLoader classLoader) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.singletonNotSet$str(), classLoader));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String alreadyRunning$str() {
        return "WFLYWELD0040: %s is already running";
    }

    @Override
    public final IllegalStateException alreadyRunning(String object) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.alreadyRunning$str(), object));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notStarted$str() {
        return "WFLYWELD0041: %s is not started";
    }

    @Override
    public final IllegalStateException notStarted(String object) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notStarted$str(), object));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanDeploymentNotFound$str() {
        return "WFLYWELD0043: BeanDeploymentArchive with id %s not found in deployment";
    }

    @Override
    public final IllegalArgumentException beanDeploymentNotFound(String beanDeploymentId) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.beanDeploymentNotFound$str(), beanDeploymentId));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindResource1$str() {
        return "WFLYWELD0044: Error injecting resource into Jakarta Contexts and Dependency Injection managed bean. Can't find a resource named %s";
    }

    @Override
    public final IllegalArgumentException couldNotFindResource(String resourceName, Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindResource1$str(), resourceName), cause);
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotDetermineResourceName$str() {
        return "WFLYWELD0045: Cannot determine resource name. Both jndiName and mappedName are null";
    }

    @Override
    public final IllegalArgumentException cannotDetermineResourceName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotDetermineResourceName$str(), new Object[0]));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInject$str() {
        return "WFLYWELD0046: Cannot inject injection point %s";
    }

    @Override
    public final IllegalArgumentException cannotInject(InjectionPoint ip) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotInject$str(), ip));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseAtRuntime$str() {
        return "WFLYWELD0047: %s cannot be used at runtime";
    }

    @Override
    public final IllegalStateException cannotUseAtRuntime(String description) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotUseAtRuntime$str(), description));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rejectAttributesMustBeTrue$str() {
        return "WFLYWELD0048: These attributes must be 'true' for use with CDI 1.0 '%s'";
    }

    @Override
    public final String rejectAttributesMustBeTrue(Set<String> keySet) {
        return String.format(this.getLoggingLocale(), this.rejectAttributesMustBeTrue$str(), keySet);
    }

    protected String couldNotFindResource2$str() {
        return "WFLYWELD0049: Error injecting resource into Jakarta Contexts and Dependency Injection managed bean. Can't find a resource named %s defined on %s";
    }

    @Override
    public final IllegalArgumentException couldNotFindResource(String resourceName, String member, Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindResource2$str(), resourceName, member), cause);
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void beanArchiveDiscovered(BeanDeploymentArchive bda) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.beanArchiveDiscovered$str(), (Object)bda);
    }

    protected String beanArchiveDiscovered$str() {
        return "Discovered %s";
    }

    protected String nameNotFoundInIndex$str() {
        return "WFLYWELD0050: %s was not found in composite index";
    }

    @Override
    public final ClassFileInfoException nameNotFoundInIndex(String name) {
        ClassFileInfoException result = new ClassFileInfoException(String.format(this.getLoggingLocale(), this.nameNotFoundInIndex$str(), name));
        WeldLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void unableToLoadAnnotation(String annotationClassName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.unableToLoadAnnotation$str(), (Object)annotationClassName);
    }

    protected String unableToLoadAnnotation$str() {
        return "Unable to load annotation %s";
    }

    protected String cannotLoadClass$str() {
        return "WFLYWELD0051: Cannot load %s";
    }

    @Override
    public final ClassFileInfoException cannotLoadClass(String name, Throwable throwable) {
        ClassFileInfoException result = new ClassFileInfoException(String.format(this.getLoggingLocale(), this.cannotLoadClass$str(), name), throwable);
        WeldLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void loadingProxiesUsingDeploymentClassLoader(ModuleIdentifier moduleIdentifier, String dependencies) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.loadingProxiesUsingDeploymentClassLoader$str(), (Object)moduleIdentifier, (Object)dependencies);
    }

    protected String loadingProxiesUsingDeploymentClassLoader$str() {
        return "WFLYWELD0052: Using deployment classloader to load proxy classes for module %s. Package-private access will not work. To fix this the module should declare dependencies on %s";
    }

    protected String componentInterceptorSupportNotAvailable$str() {
        return "WFLYWELD0053: Component interceptor support not available for: %s";
    }

    @Override
    public final IllegalStateException componentInterceptorSupportNotAvailable(Object componentClass) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentInterceptorSupportNotAvailable$str(), componentClass));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotLoadAnnotationIndexOfExternalBeanArchive(Object indexUrl) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotLoadAnnotationIndexOfExternalBeanArchive$str(), indexUrl);
    }

    protected String cannotLoadAnnotationIndexOfExternalBeanArchive$str() {
        return "WFLYWELD0054: Could not read provided index of an external bean archive: %s";
    }

    @Override
    public final void cannotIndexClassName(Object name, Object bda) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotIndexClassName$str(), name, bda);
    }

    protected String cannotIndexClassName$str() {
        return "WFLYWELD0055: Could not index class [%s] from an external bean archive: %s";
    }

    protected String weldNotInitialized$str() {
        return "WFLYWELD0056: Weld is not initialized yet";
    }

    @Override
    public final IllegalStateException weldNotInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.weldNotInitialized$str(), new Object[0]));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String persistenceUnitFailed$str() {
        return "WFLYWELD0057: Persistence unit '%s' failed.";
    }

    @Override
    public final IllegalStateException persistenceUnitFailed(String scopedPuName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.persistenceUnitFailed$str(), scopedPuName));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String persistenceUnitRemoved$str() {
        return "WFLYWELD0058: Persistence unit '%s' removed.";
    }

    @Override
    public final IllegalStateException persistenceUnitRemoved(String scopedPuName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.persistenceUnitRemoved$str(), scopedPuName));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownDeploymentType$str() {
        return "WFLYWELD0059: Unknown deployment type %s";
    }

    @Override
    public final IllegalArgumentException unknownDeploymentType(DeploymentType deploymentType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownDeploymentType$str(), deploymentType));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorHandlingFile$str() {
        return "WFLYWELD0060: Error handling file %s";
    }

    @Override
    public final RuntimeException errorHandlingFile(File file, Throwable throwable) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorHandlingFile$str(), file), throwable);
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingService$str() {
        return "WFLYWELD0061: Exactly one service provider is required for: %s";
    }

    @Override
    public final IllegalStateException missingService(Class<?> serviceClass) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingService$str(), serviceClass));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotDeterminePackage$str() {
        return "WFLYWELD0062: Could not determine package from corrupted class name";
    }

    @Override
    public final IllegalStateException couldNotDeterminePackage() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotDeterminePackage$str(), new Object[0]));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String originalClassDoesNotHaveAModule$str() {
        return "WFLYWELD0063: Original %s does not have a module";
    }

    @Override
    public final IllegalArgumentException originalClassDoesNotHaveAModule(Class<?> originalClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.originalClassDoesNotHaveAModule$str(), originalClass));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectBceTranslatorSetup$str() {
        return "WFLYWELD0064: Incorrect setup for Weld's LiteExtensionTranslator initialization; a deployment unit has to be specified";
    }

    @Override
    public final IllegalArgumentException incorrectBceTranslatorSetup() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.incorrectBceTranslatorSetup$str(), new Object[0]));
        WeldLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

