/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.http.impl.cookie;

import wiremock.webhooks.org.apache.http.annotation.Contract;
import wiremock.webhooks.org.apache.http.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.http.cookie.CommonCookieAttributeHandler;
import wiremock.webhooks.org.apache.http.cookie.Cookie;
import wiremock.webhooks.org.apache.http.cookie.CookieOrigin;
import wiremock.webhooks.org.apache.http.cookie.MalformedCookieException;
import wiremock.webhooks.org.apache.http.cookie.SetCookie;
import wiremock.webhooks.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import wiremock.webhooks.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

