/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.http.impl.io;

import java.io.IOException;
import wiremock.webhooks.org.apache.http.Header;
import wiremock.webhooks.org.apache.http.HeaderIterator;
import wiremock.webhooks.org.apache.http.HttpException;
import wiremock.webhooks.org.apache.http.HttpMessage;
import wiremock.webhooks.org.apache.http.io.HttpMessageWriter;
import wiremock.webhooks.org.apache.http.io.SessionOutputBuffer;
import wiremock.webhooks.org.apache.http.message.BasicLineFormatter;
import wiremock.webhooks.org.apache.http.message.LineFormatter;
import wiremock.webhooks.org.apache.http.params.HttpParams;
import wiremock.webhooks.org.apache.http.util.Args;
import wiremock.webhooks.org.apache.http.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

