/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.http.protocol;

import java.io.IOException;
import wiremock.webhooks.org.apache.http.HttpException;
import wiremock.webhooks.org.apache.http.HttpRequest;
import wiremock.webhooks.org.apache.http.HttpRequestInterceptor;
import wiremock.webhooks.org.apache.http.annotation.Contract;
import wiremock.webhooks.org.apache.http.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.http.protocol.HttpContext;
import wiremock.webhooks.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

