/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.http.protocol;

import java.io.IOException;
import wiremock.webhooks.org.apache.http.HttpEntityEnclosingRequest;
import wiremock.webhooks.org.apache.http.HttpException;
import wiremock.webhooks.org.apache.http.HttpRequest;
import wiremock.webhooks.org.apache.http.HttpRequestInterceptor;
import wiremock.webhooks.org.apache.http.annotation.Contract;
import wiremock.webhooks.org.apache.http.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.http.protocol.HttpContext;
import wiremock.webhooks.org.apache.http.protocol.HttpDateGenerator;
import wiremock.webhooks.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

