/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.simple.extend.URLUTF8Encoder;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormListener;
import org.xhtmlrenderer.simple.xhtml.controls.AbstractControl;
import org.xhtmlrenderer.simple.xhtml.controls.ButtonControl;
import org.xhtmlrenderer.simple.xhtml.controls.CheckControl;
import org.xhtmlrenderer.simple.xhtml.controls.HiddenControl;
import org.xhtmlrenderer.simple.xhtml.controls.SelectControl;
import org.xhtmlrenderer.simple.xhtml.controls.TextControl;

public class XhtmlForm {
    private final String _action;
    private final String _method;
    private final List<FormControl> _controls = new ArrayList<FormControl>();
    private final List<FormListener> _listeners = new ArrayList<FormListener>();

    public XhtmlForm(String action, String method) {
        this._action = action;
        this._method = method;
    }

    public void addFormListener(FormListener listener) {
        this._listeners.add(listener);
    }

    public void removeFormListener(FormListener listener) {
        this._listeners.remove(listener);
    }

    public FormControl getControl(String name) {
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            return control;
        }
        return null;
    }

    public List<FormControl> getAllControls(String name) {
        ArrayList<FormControl> result = new ArrayList<FormControl>();
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            result.add(control);
        }
        return result;
    }

    public Iterable<FormControl> controls() {
        return this._controls;
    }

    @Deprecated
    public Iterator<FormControl> getControls() {
        return this._controls.iterator();
    }

    public FormControl createControl(Element e) {
        return XhtmlForm.createControl(this, e);
    }

    public static FormControl createControl(XhtmlForm form, Element e) {
        AbstractControl control;
        String name;
        if (e == null) {
            return null;
        }
        block6 : switch (name = e.getNodeName()) {
            case "input": {
                String type;
                switch (type = e.getAttribute("type")) {
                    case "text": 
                    case "password": {
                        control = new TextControl(form, e);
                        break block6;
                    }
                    case "hidden": {
                        control = new HiddenControl(form, e);
                        break block6;
                    }
                    case "button": 
                    case "submit": 
                    case "reset": {
                        control = new ButtonControl(form, e);
                        break block6;
                    }
                    case "checkbox": 
                    case "radio": {
                        control = new CheckControl(form, e);
                        break block6;
                    }
                }
                return null;
            }
            case "textarea": {
                control = new TextControl(form, e);
                break;
            }
            case "button": {
                control = new ButtonControl(form, e);
                break;
            }
            case "select": {
                control = new SelectControl(form, e);
                break;
            }
            default: {
                return null;
            }
        }
        if (form != null) {
            form._controls.add(control);
        }
        return control;
    }

    public void reset() {
        for (FormListener listener : this._listeners) {
            listener.resetted(this);
        }
    }

    public void submit() {
        StringBuilder data = new StringBuilder();
        for (FormControl control : this._controls) {
            if (!control.isSuccessful()) continue;
            if (control.isMultiple()) {
                String[] values;
                for (String value : values = control.getMultipleValues()) {
                    if (data.length() > 0) {
                        data.append('&');
                    }
                    data.append(URLUTF8Encoder.encode(control.getName()));
                    data.append('=');
                    data.append(URLUTF8Encoder.encode(value));
                }
                continue;
            }
            if (data.length() > 0) {
                data.append('&');
            }
            data.append(URLUTF8Encoder.encode(control.getName()));
            data.append('=');
            data.append(URLUTF8Encoder.encode(control.getValue()));
        }
        System.out.println("Form submitted!");
        System.out.println("Action: " + this._action);
        System.out.println("Method: " + this._method);
        System.out.println("Data: " + data);
        for (FormListener listener : this._listeners) {
            listener.submitted(this);
        }
    }
}

