/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.simple.NoNamespaceHandler;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.TextUtil;
import org.xhtmlrenderer.util.XRLog;

@ParametersAreNonnullByDefault
public class XhtmlCssOnlyNamespaceHandler
extends NoNamespaceHandler {
    private static final String _namespace = "http://www.w3.org/1999/xhtml";
    private static StylesheetInfo _defaultStylesheet;
    private static boolean _defaultStylesheetError;

    @Override
    @Nonnull
    @CheckReturnValue
    public String getNamespace() {
        return _namespace;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getClass(Element e) {
        return e.getAttribute("class");
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String getID(Element e) {
        String result = e.getAttribute("id").trim();
        return result.isEmpty() ? null : result;
    }

    protected String convertToLength(String value) {
        if (this.isInteger(value)) {
            return value + "px";
        }
        return value;
    }

    protected boolean isInteger(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected String getAttribute(Element e, String attrName) {
        String result = e.getAttribute(attrName).trim();
        return result.isEmpty() ? null : result;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getElementStyling(Element e) {
        StringBuilder style = new StringBuilder();
        switch (e.getNodeName()) {
            case "td": 
            case "th": {
                String s = this.getAttribute(e, "colspan");
                if (s != null) {
                    style.append("-fs-table-cell-colspan: ");
                    style.append(s);
                    style.append(";");
                }
                if ((s = this.getAttribute(e, "rowspan")) == null) break;
                style.append("-fs-table-cell-rowspan: ");
                style.append(s);
                style.append(";");
                break;
            }
            case "img": {
                String s = this.getAttribute(e, "width");
                if (s != null) {
                    style.append("width: ");
                    style.append(this.convertToLength(s));
                    style.append(";");
                }
                if ((s = this.getAttribute(e, "height")) == null) break;
                style.append("height: ");
                style.append(this.convertToLength(s));
                style.append(";");
                break;
            }
            case "colgroup": 
            case "col": {
                String s = this.getAttribute(e, "span");
                if (s != null) {
                    style.append("-fs-table-cell-colspan: ");
                    style.append(s);
                    style.append(";");
                }
                if ((s = this.getAttribute(e, "width")) == null) break;
                style.append("width: ");
                style.append(this.convertToLength(s));
                style.append(";");
                break;
            }
        }
        style.append(e.getAttribute("style"));
        return style.toString();
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String getLinkUri(Element e) {
        return e.getNodeName().equalsIgnoreCase("a") && e.hasAttribute("href") ? e.getAttribute("href") : null;
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String getAnchorName(@Nullable Element e) {
        if (e != null && "a".equalsIgnoreCase(e.getNodeName()) && e.hasAttribute("name")) {
            return e.getAttribute("name");
        }
        return null;
    }

    private static String collapseWhiteSpace(String text) {
        StringBuilder result = new StringBuilder();
        int l = text.length();
        block0: for (int i = 0; i < l; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                result.append(' ');
                while (++i < l) {
                    c = text.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    --i;
                    continue block0;
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getDocumentTitle(Document doc) {
        Element titleElem;
        String title = "";
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null && (titleElem = this.findFirstChild(head, "title")) != null) {
            title = XhtmlCssOnlyNamespaceHandler.collapseWhiteSpace(TextUtil.readTextContent(titleElem).trim());
        }
        return title;
    }

    private Element findFirstChild(Element parent, String targetName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(targetName)) continue;
            return (Element)n;
        }
        return null;
    }

    protected StylesheetInfo readStyleElement(Element style) {
        String media = style.getAttribute("media");
        if (media.isEmpty()) {
            media = "all";
        }
        StylesheetInfo info = new StylesheetInfo();
        info.setMedia(media);
        info.setType(style.getAttribute("type"));
        info.setTitle(style.getAttribute("title"));
        info.setOrigin(2);
        StringBuilder buf = new StringBuilder();
        for (Node current = style.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!(current instanceof CharacterData)) continue;
            buf.append(((CharacterData)current).getData());
        }
        String css = buf.toString().trim();
        if (!css.isEmpty()) {
            info.setContent(css);
            return info;
        }
        return null;
    }

    protected StylesheetInfo readLinkElement(Element link) {
        String rel = link.getAttribute("rel").toLowerCase();
        if (rel.contains("alternate")) {
            return null;
        }
        if (!rel.contains("stylesheet")) {
            return null;
        }
        String type = link.getAttribute("type");
        if (!type.isEmpty() && !type.equals("text/css")) {
            return null;
        }
        StylesheetInfo info = new StylesheetInfo();
        if (type.isEmpty()) {
            type = "text/css";
        }
        info.setType(type);
        info.setOrigin(2);
        info.setUri(link.getAttribute("href"));
        String media = link.getAttribute("media");
        if (media.isEmpty()) {
            media = "all";
        }
        info.setMedia(media);
        String title = link.getAttribute("title");
        info.setTitle(title);
        return info;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public List<StylesheetInfo> getStylesheets(Document doc) {
        ArrayList<StylesheetInfo> result = new ArrayList<StylesheetInfo>(super.getStylesheets(doc));
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null) {
            for (Node current = head.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 1) continue;
                Element elem = (Element)current;
                StylesheetInfo info = null;
                String elemName = elem.getLocalName();
                if (elemName == null) {
                    elemName = elem.getTagName();
                }
                if (elemName.equals("link")) {
                    info = this.readLinkElement(elem);
                } else if (elemName.equals("style")) {
                    info = this.readStyleElement(elem);
                }
                if (info == null) continue;
                result.add(info);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @CheckReturnValue
    public StylesheetInfo getDefaultStylesheet(StylesheetFactory factory) {
        Class<XhtmlCssOnlyNamespaceHandler> clazz = XhtmlCssOnlyNamespaceHandler.class;
        synchronized (XhtmlCssOnlyNamespaceHandler.class) {
            if (_defaultStylesheet != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return _defaultStylesheet;
            }
            if (_defaultStylesheetError) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            StylesheetInfo info = new StylesheetInfo();
            info.setUri(this.getNamespace());
            info.setOrigin(0);
            info.setMedia("all");
            info.setType("text/css");
            try (InputStream is = this.getDefaultStylesheetStream();){
                if (_defaultStylesheetError) {
                    StylesheetInfo stylesheetInfo = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return stylesheetInfo;
                }
                Stylesheet sheet = factory.parse(new InputStreamReader(is), info);
                info.setStylesheet(sheet);
            }
            catch (IOException e) {
                _defaultStylesheetError = true;
                XRLog.exception("Could not parse default stylesheet", e);
            }
            _defaultStylesheet = info;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _defaultStylesheet;
        }
    }

    private InputStream getDefaultStylesheetStream() {
        String defaultStyleSheet = Configuration.valueFor("xr.css.user-agent-default-css") + "XhtmlNamespaceHandler.css";
        InputStream stream = this.getClass().getResourceAsStream(defaultStyleSheet);
        if (stream == null) {
            XRLog.exception("Can't load default CSS from " + defaultStyleSheet + ".This file must be on your CLASSPATH. Please check before continuing.");
            _defaultStylesheetError = true;
        }
        return stream;
    }

    private Map<String, String> getMetaInfo(Document doc) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null) {
            for (Node current = head.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 1) continue;
                Element elem = (Element)current;
                String elemName = elem.getLocalName();
                if (elemName == null) {
                    elemName = elem.getTagName();
                }
                if (!elemName.equals("meta")) continue;
                String http_equiv = elem.getAttribute("http-equiv");
                String content = elem.getAttribute("content");
                if (http_equiv.isEmpty() || content.isEmpty()) continue;
                metadata.put(http_equiv, content);
            }
        }
        return metadata;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getLang(@Nullable Element e) {
        if (e == null) {
            return "";
        }
        String lang = e.getAttribute("lang");
        if (lang.isEmpty() && (lang = this.getMetaInfo(e.getOwnerDocument()).get("Content-Language")) == null) {
            lang = "";
        }
        return lang;
    }
}

