/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swing.BoxRenderer;
import org.xhtmlrenderer.test.Regress;
import org.xhtmlrenderer.util.IOUtil;

public class ReferenceComparison {
    private final int width;
    private final boolean isVerbose;
    private static final String LINE_SEPARATOR = "\n";

    public static void main(String[] args) throws IOException {
        ReferenceComparison rc = new ReferenceComparison(1024, false);
        File source = new File(args[0]);
        File reference = new File(args[1]);
        File failed = new File(args[2]);
        rc.compareDirectory(source, reference, failed);
    }

    public ReferenceComparison(int width, boolean verbose) {
        this.width = width;
        this.isVerbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareDirectory(File sourceDirectory, File referenceDir, File failedDirectory) throws IOException {
        this.checkDirectories(sourceDirectory, referenceDir, failedDirectory);
        this.log("Starting comparison using width " + this.width);
        IOUtil.deleteAllFiles(failedDirectory);
        boolean wasEnabled = this.enableLogging(false);
        try {
            CompareStatistics stats = new CompareStatistics();
            for (File file : this.listSourceFiles(sourceDirectory)) {
                try {
                    this.compareFile(file, referenceDir, failedDirectory, stats);
                }
                catch (IOException e) {
                    stats.failedIOException(e);
                }
            }
            stats.report();
        }
        finally {
            this.enableLogging(wasEnabled);
        }
    }

    private boolean enableLogging(boolean isEnabled) {
        String prop = "xr.util-logging.loggingEnabled";
        boolean orgVal = Boolean.parseBoolean(System.getProperty("xr.util-logging.loggingEnabled"));
        System.setProperty("xr.util-logging.loggingEnabled", Boolean.valueOf(isEnabled).toString());
        return orgVal;
    }

    private void checkDirectories(File sourceDirectory, File referenceDir, File failedDirectory) {
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Source dir. doesn't exist, or not a directory: " + sourceDirectory);
        }
        if (!referenceDir.exists() || !referenceDir.isDirectory()) {
            throw new IllegalArgumentException("Reference dir. doesn't exist, or not a directory: " + referenceDir);
        }
        if (failedDirectory.exists() && !failedDirectory.isDirectory()) {
            throw new IllegalArgumentException("Need directory for failed matches, not a directory: " + failedDirectory);
        }
        if (!failedDirectory.exists() && !failedDirectory.mkdirs()) {
            throw new RuntimeException("Could not create directory path (.mkdirs failed without an exception) " + failedDirectory.getAbsolutePath());
        }
    }

    private boolean verbose() {
        return this.isVerbose;
    }

    private Iterable<File> listSourceFiles(File sourceDirectory) {
        File[] files = sourceDirectory.listFiles((dir, name) -> Regress.EXTENSIONS.contains(name.substring(name.lastIndexOf(".") + 1)));
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    void compareFile(File source, File referenceDir, File failedDirectory, CompareStatistics stat) throws IOException {
        String laidOut;
        String refLaidOut;
        Box box;
        this.log("Comparing " + source.getPath());
        stat.checking(source);
        BoxRenderer renderer = new BoxRenderer(source, this.width);
        try {
            this.log("rendering");
            box = renderer.render();
            this.log("rendered");
        }
        catch (Exception e) {
            e.printStackTrace();
            stat.failedToRender(e);
            this.storeFailed(failedDirectory, source);
            this.log("Could not render input file, skipping: " + source + " err: " + e.getMessage());
            return;
        }
        LayoutContext layoutContext = renderer.getLayoutContext();
        String inputFileName = source.getName();
        String refRendered = this.trimTrailingLS(this.readReference(referenceDir, inputFileName, ".render.txt"));
        String rendered = this.trimTrailingLS(box.dump(layoutContext, "", 2));
        if (!this.compareLines(refRendered, rendered, stat)) {
            this.storeFailed(failedDirectory, new File(referenceDir, inputFileName), ".render.txt", rendered);
        }
        if (!this.compareLines(refLaidOut = this.trimTrailingLS(this.readReference(referenceDir, inputFileName, ".layout.txt")), laidOut = this.trimTrailingLS(box.dump(layoutContext, "", 1)), stat)) {
            this.storeFailed(failedDirectory, new File(referenceDir, inputFileName), ".layout.txt", laidOut);
        }
    }

    private String trimTrailingLS(String s) {
        if (s.endsWith(LINE_SEPARATOR)) {
            s = s.substring(0, s.length() - LINE_SEPARATOR.length());
        }
        return s;
    }

    private void storeFailed(File failedDirectory, File refFile, String suffix, String compareTo) {
        this.copyToFailed(failedDirectory, refFile, "");
        this.copyToFailed(failedDirectory, refFile, ".png");
        this.copyToFailed(failedDirectory, refFile, suffix);
        try (OutputStreamWriter fw = new OutputStreamWriter(Files.newOutputStream(new File(failedDirectory, refFile.getName() + ".err" + suffix).toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            try (BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(compareTo);
                bw.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected IO exception on writing 'failed' info for test.", e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IO exception on writing 'failed' info for test.", e);
        }
    }

    private void copyToFailed(File failedDirectory, File refFile, String suffix) {
        File source = new File(failedDirectory, refFile.getName() + suffix);
        if (!source.exists()) {
            source = new File(refFile.getAbsoluteFile().getParentFile(), refFile.getName() + suffix);
            try {
                IOUtil.copyFile(source, failedDirectory);
            }
            catch (IOException e) {
                System.err.println("Failed to copy file (reference) " + source + " to failed directory, err " + e.getMessage());
            }
        }
    }

    private boolean compareLines(String refText, String text, CompareStatistics statistics) throws IOException {
        this.log("running comparison");
        try (LineNumberReader lnrRef = new LineNumberReader(new StringReader(refText));
             LineNumberReader lnrOther = new LineNumberReader(new StringReader(text));){
            String lineRef;
            while ((lineRef = lnrRef.readLine()) != null) {
                String lineOther = lnrOther.readLine();
                if (lineOther == null) {
                    statistics.failedRefIsLonger();
                    boolean bl = false;
                    return bl;
                }
                if (lineRef.equals(lineOther)) continue;
                statistics.failedDontMatch(lineRef, lineOther);
                boolean bl = false;
                return bl;
            }
            if (lnrOther.readLine() != null) {
                statistics.failedOtherIsLonger();
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void storeFailed(File failedDirectory, File sourceFile) {
        try {
            IOUtil.copyFile(sourceFile, failedDirectory);
        }
        catch (IOException e) {
            System.err.println("Failed to copy file to failed directory: " + sourceFile + ", err: " + e.getMessage());
        }
    }

    private String readReference(File referenceDir, String input, String sfx) throws IOException {
        File f = new File(referenceDir, input + sfx);
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(Files.newInputStream(f.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = rdr.readLine()) != null) {
                sb.append(line);
                sb.append(LINE_SEPARATOR);
            }
            String string = sb.toString();
            return string;
        }
    }

    private void log(String msg) {
        if (this.verbose()) {
            System.out.println(msg);
        }
    }

    private static class CompareStatistics {
        private File currentFile;
        private static final Result OK = new ResultOK();
        private final Map<File, Result> files = new HashMap<File, Result>();

        private CompareStatistics() {
        }

        private void failedToRender(Exception e) {
            this.files.put(this.currentFile, new RenderFailed(e));
        }

        private void failedRefIsLonger() {
            this.files.put(this.currentFile, new RefIsLonger());
        }

        private void failedDontMatch(String lineRef, String lineOther) {
            this.files.put(this.currentFile, new LineMismatch(lineRef, lineOther));
        }

        private void failedOtherIsLonger() {
            this.files.put(this.currentFile, new OtherIsLonger());
        }

        private void failedIOException(IOException e) {
            this.files.put(this.currentFile, new FailedIO(e));
        }

        private void checking(File source) {
            this.currentFile = source;
            this.files.put(this.currentFile, OK);
        }

        private void report() {
            int failed = 0;
            for (File file : this.files.keySet()) {
                Result result = this.files.get(file);
                if (!(result instanceof FailedResult)) continue;
                ++failed;
                System.out.println(result.describe(file));
            }
            System.out.println("Checked " + this.files.keySet().size() + " files, " + (String)(failed > 0 ? failed + " failed." : "all OK."));
        }

        private record RenderFailed(Exception exception) implements Result
        {
            @Override
            public String describe(File file) {
                return "FAIL: Render operation threw exception for %s, err %s".formatted(file.getName(), this.exception.getMessage());
            }
        }

        private static class RefIsLonger
        implements FailedResult {
            private RefIsLonger() {
            }

            @Override
            public String describe(File file) {
                return "FAIL: reference is longer (more lines): %s".formatted(file.getName());
            }
        }

        private record LineMismatch(String lineRef, String lineOther) implements FailedResult
        {
            @Override
            public String describe(File file) {
                return "FAIL: line content doesn't match for %s%sref: %s%sother: %s".formatted(file.getName(), ReferenceComparison.LINE_SEPARATOR, this.lineRef, ReferenceComparison.LINE_SEPARATOR, this.lineOther);
            }
        }

        private static class OtherIsLonger
        implements FailedResult {
            private OtherIsLonger() {
            }

            @Override
            public String describe(File file) {
                return "FAIL: new rendered output is longer (more lines): %s".formatted(file.getName());
            }
        }

        private static class FailedIO
        implements FailedResult {
            private final IOException exception;

            public FailedIO(IOException e) {
                this.exception = e;
            }

            @Override
            public String describe(File file) {
                return "FAIL: IOException when comparing: %s (err: %s".formatted(file, this.exception.getMessage());
            }
        }

        private static interface Result {
            public String describe(File var1);
        }

        private static interface FailedResult
        extends Result {
        }

        private static class ResultOK
        implements Result {
            private ResultOK() {
            }

            @Override
            public String describe(File file) {
                return "OK: %s".formatted(file.getName());
            }
        }
    }
}

