/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import smartrics.rest.client.RestClient;
import smartrics.rest.client.RestClientImpl;
import smartrics.rest.client.RestRequest;
import smartrics.rest.fitnesse.fixture.FitFormatter;
import smartrics.rest.fitnesse.fixture.RestFixture;
import smartrics.rest.fitnesse.fixture.SlimFormatter;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapterFactory;
import smartrics.rest.fitnesse.fixture.support.CellFormatter;
import smartrics.rest.fitnesse.fixture.support.Config;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.HttpClientBuilder;

public class PartsFactory {
    public RestClient buildRestClient(final Config config) {
        HttpClient httpClient = new HttpClientBuilder().createHttpClient(config);
        return new RestClientImpl(httpClient){

            protected URI createUri(String uriString, boolean escaped) throws URIException {
                boolean useNewHttpUriFactory = config.getAsBoolean("http.client.use.new.http.uri.factory", false);
                if (useNewHttpUriFactory) {
                    return new HttpURL(uriString);
                }
                return super.createUri(uriString, escaped);
            }

            public String getMethodClassnameFromMethodName(String mName) {
                boolean useOverriddenHttpMethodImpl = config.getAsBoolean("http.client.use.new.http.uri.factory", false);
                if (useOverriddenHttpMethodImpl) {
                    return String.format("smartrics.rest.fitnesse.fixture.support.http.%sMethod", mName);
                }
                return super.getMethodClassnameFromMethodName(mName);
            }
        };
    }

    public RestRequest buildRestRequest() {
        return new RestRequest();
    }

    public CellFormatter<?> buildCellFormatter(RestFixture.Runner runner) {
        if (runner == null) {
            throw new IllegalArgumentException("Runner is null");
        }
        if (RestFixture.Runner.SLIM.equals((Object)runner)) {
            return new SlimFormatter();
        }
        if (RestFixture.Runner.FIT.equals((Object)runner)) {
            return new FitFormatter();
        }
        throw new IllegalStateException("Runner " + runner.name() + " not supported");
    }

    public BodyTypeAdapter buildBodyTypeAdapter(ContentType ct, String charset) {
        return BodyTypeAdapterFactory.getBodyTypeAdapter(ct, charset);
    }
}

