/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import smartrics.rest.fitnesse.fixture.support.CellFormatter;
import smartrics.rest.fitnesse.fixture.support.CellWrapper;
import smartrics.rest.fitnesse.fixture.support.RestDataTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.Tools;

public class SlimFormatter
implements CellFormatter<String> {
    private int minLenForToggle = -1;
    private boolean displayActual;

    @Override
    public void setDisplayActual(boolean d) {
        this.displayActual = d;
    }

    @Override
    public void setMinLenghtForToggleCollapse(int minLen) {
        this.minLenForToggle = minLen;
    }

    @Override
    public boolean isDisplayActual() {
        return this.displayActual;
    }

    @Override
    public void exception(CellWrapper<String> cell, String exceptionMessage) {
        cell.body("error:" + exceptionMessage);
    }

    @Override
    public void exception(CellWrapper<String> cell, Throwable exception) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        exception.printStackTrace(ps);
        String m = Tools.toHtml(cell.getWrapped() + "\n-----\n") + Tools.toCode(Tools.toHtml(out.toString()));
        cell.body("error:" + m);
    }

    @Override
    public void check(CellWrapper<String> expected, RestDataTypeAdapter actual) {
        if (null == expected.body() || "".equals(expected.body())) {
            if (actual.get() == null) {
                return;
            }
            expected.body(this.gray(actual.get().toString()));
            return;
        }
        if (actual.get() != null && actual.equals(expected.body(), actual.get().toString())) {
            this.right(expected, actual);
        } else {
            this.wrong(expected, actual);
        }
    }

    @Override
    public String label(String string) {
        return Tools.toHtmlLabel(string);
    }

    @Override
    public void wrong(CellWrapper<String> expected, RestDataTypeAdapter ta) {
        String expectedContent = expected.body();
        expected.body(Tools.makeContentForWrongCell(expectedContent, ta, this, this.minLenForToggle));
        expected.body("fail:" + expected.body());
    }

    @Override
    public void right(CellWrapper<String> expected, RestDataTypeAdapter typeAdapter) {
        expected.body("pass:" + Tools.makeContentForRightCell(expected.body(), typeAdapter, this, this.minLenForToggle));
    }

    @Override
    public String gray(String string) {
        return "report:" + Tools.toHtml(string);
    }

    @Override
    public void asLink(CellWrapper<String> cell, String link, String text) {
        cell.body("report:" + Tools.toHtmlLink(link, text));
    }

    @Override
    public String fromRaw(String text) {
        return Tools.fromHtml(text);
    }
}

