/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.JSONBodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.TextBodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.XPathBodyTypeAdapter;

public class BodyTypeAdapterFactory {
    private static Map<ContentType, Class> contentTypeToBodyTypeAdapter = new HashMap<ContentType, Class>();

    private BodyTypeAdapterFactory() {
    }

    public static BodyTypeAdapter getBodyTypeAdapter(ContentType content, String charset) {
        Class aClass = contentTypeToBodyTypeAdapter.get((Object)content);
        if (aClass == null) {
            throw new IllegalArgumentException("Content-Type is UNKNOWN.  Unable to find a BodyTypeAdapter to instantiate.");
        }
        BodyTypeAdapter instance = null;
        try {
            instance = (BodyTypeAdapter)((Object)aClass.newInstance());
            if (charset != null) {
                instance.setCharset(charset);
            } else {
                instance.setCharset(Charset.defaultCharset().name());
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate a the BodyTypeAdapter for " + (Object)((Object)content) + "(" + aClass.getName() + ")");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable access ctor to instantiate a the BodyTypeAdapter for " + (Object)((Object)content) + "(" + aClass.getName() + ")");
        }
        return instance;
    }

    static {
        contentTypeToBodyTypeAdapter.put(ContentType.JS, JSONBodyTypeAdapter.class);
        contentTypeToBodyTypeAdapter.put(ContentType.JSON, JSONBodyTypeAdapter.class);
        contentTypeToBodyTypeAdapter.put(ContentType.XML, XPathBodyTypeAdapter.class);
        contentTypeToBodyTypeAdapter.put(ContentType.TEXT, TextBodyTypeAdapter.class);
    }
}

