/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartrics.rest.fitnesse.fixture.support.JavascriptWrapper;
import smartrics.rest.fitnesse.fixture.support.Tools;
import smartrics.rest.fitnesse.fixture.support.XPathBodyTypeAdapter;

public class JSONBodyTypeAdapter
extends XPathBodyTypeAdapter {
    private static Logger LOG = LoggerFactory.getLogger(JSONBodyTypeAdapter.class);
    private boolean forceJsEvaluation = false;
    private JavascriptWrapper wrapper = new JavascriptWrapper();

    @Override
    protected boolean eval(String expr, String json) {
        if (!this.forceJsEvaluation && Tools.isValidXPath(this.getContext(), expr) && !this.wrapper.looksLikeAJsExpression(expr)) {
            LOG.warn("XPath expectations in JSON content are deprecated. Please use JavaScript expressions.");
            String xml = Tools.fromJSONtoXML(json);
            return super.eval(expr, xml);
        }
        Object exprResult = this.wrapper.evaluateExpression(json, expr);
        if (exprResult == null) {
            return false;
        }
        return Boolean.parseBoolean(exprResult.toString());
    }

    @Override
    public Object parse(String possibleJsContent) throws Exception {
        if (possibleJsContent == null || possibleJsContent.trim().indexOf("/* javascript */") < 0) {
            this.forceJsEvaluation = false;
            return super.parse(possibleJsContent);
        }
        this.forceJsEvaluation = true;
        String content = Tools.fromHtml(possibleJsContent.trim());
        return content;
    }

    @Override
    public boolean equals(Object expected, Object actual) {
        if (this.checkNoBody(expected)) {
            return this.checkNoBody(actual);
        }
        if (this.checkNoBody(actual)) {
            return this.checkNoBody(expected);
        }
        if (expected instanceof List) {
            return super.equals(expected, actual);
        }
        boolean result = false;
        if (expected instanceof String && !(result = this.eval(expected.toString(), actual.toString()))) {
            this.addError("not found: '" + expected.toString() + "'");
        }
        return result;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null || obj.toString().trim().equals("")) {
            return "no-body";
        }
        return obj.toString();
    }

    @Override
    public String toXmlString(String content) {
        return Tools.fromJSONtoXML(content);
    }
}

