/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import smartrics.rest.client.RestData;
import smartrics.rest.client.RestResponse;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.JavascriptException;
import smartrics.rest.fitnesse.fixture.support.Tools;
import smartrics.rest.fitnesse.fixture.support.Variables;

public class JavascriptWrapper {
    public static final String RESPONSE_OBJ_NAME = "response";
    public static final String SYMBOLS_OBJ_NAME = "symbols";
    public static final String JSON_OBJ_NAME = "jsonbody";

    public Object evaluateExpression(RestResponse response, String expression) {
        if (expression == null) {
            return null;
        }
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        this.injectFitNesseSymbolMap(scope);
        this.injectResponse(context, scope, response);
        Object result = this.evaluateExpression(context, scope, expression);
        return result;
    }

    public Object evaluateExpression(String json, String expression) {
        if (json == null || expression == null) {
            return null;
        }
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        this.injectFitNesseSymbolMap(scope);
        this.injectJson(context, scope, json);
        Object result = this.evaluateExpression(context, scope, expression);
        return result;
    }

    public boolean looksLikeAJsExpression(String json) {
        return json != null && json.contains("jsonbody.");
    }

    private void injectFitNesseSymbolMap(ScriptableObject scope) {
        Variables v = new Variables();
        Object wrappedVariables = Context.javaToJS((Object)v, (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)SYMBOLS_OBJ_NAME, (Object)wrappedVariables);
    }

    private void injectJson(Context cx, ScriptableObject scope, String json) {
        this.evaluateExpression(cx, scope, "var jsonbody=" + json);
    }

    private Object evaluateExpression(Context context, ScriptableObject scope, String expression) {
        try {
            Object result = context.evaluateString((Scriptable)scope, expression, null, 1, null);
            return result;
        }
        catch (EvaluatorException e) {
            throw new JavascriptException(e.getMessage());
        }
        catch (EcmaError e) {
            throw new JavascriptException(e.getMessage());
        }
    }

    private void injectResponse(Context cx, ScriptableObject scope, RestResponse r) {
        try {
            ScriptableObject.defineClass((Scriptable)scope, JsResponse.class);
            Scriptable response = null;
            if (r == null) {
                scope.put(RESPONSE_OBJ_NAME, (Scriptable)scope, response);
                return;
            }
            Object[] arg = new Object[]{r};
            response = cx.newObject((Scriptable)scope, "JsResponse", arg);
            scope.put(RESPONSE_OBJ_NAME, (Scriptable)scope, (Object)response);
            this.putPropertyOnJsObject(response, "body", r.getBody());
            this.putPropertyOnJsObject(response, JSON_OBJ_NAME, null);
            boolean isJson = this.isJsonResponse(r);
            if (isJson) {
                this.evaluateExpression(cx, scope, "response.jsonbody=" + r.getBody());
            }
            this.putPropertyOnJsObject(response, "resource", r.getResource());
            this.putPropertyOnJsObject(response, "statusText", r.getStatusText());
            this.putPropertyOnJsObject(response, "statusCode", r.getStatusCode());
            this.putPropertyOnJsObject(response, "transactionId", r.getTransactionId());
            for (RestData.Header h : r.getHeaders()) {
                this.callMethodOnJsObject(response, "addHeader", h.getName(), h.getValue());
            }
        }
        catch (IllegalAccessException e) {
            throw new JavascriptException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new JavascriptException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new JavascriptException(e.getMessage());
        }
    }

    private void callMethodOnJsObject(Scriptable o, String mName, Object ... arg) {
        ScriptableObject.callMethod((Scriptable)o, (String)mName, (Object[])arg);
    }

    private void putPropertyOnJsObject(Scriptable o, String mName, Object value) {
        ScriptableObject.putProperty((Scriptable)o, (String)mName, (Object)value);
    }

    private boolean isJsonResponse(RestResponse r) {
        if (ContentType.JSON.equals((Object)ContentType.parse(r.getContentType()))) {
            return true;
        }
        if (r.getBody() != null && r.getBody().trim().matches("\\{.+\\}")) {
            return Tools.isValidJson(r.getBody());
        }
        return false;
    }

    public static class JsResponse
    extends ScriptableObject {
        private static final long serialVersionUID = 5441026774653915695L;
        private Map<String, List<String>> headers;

        public void jsConstructor() {
            this.headers = new HashMap<String, List<String>>();
        }

        public String getClassName() {
            return "JsResponse";
        }

        public void jsFunction_addHeader(String name, String value) {
            List<String> vals = this.headers.get(name);
            if (vals == null) {
                vals = new ArrayList<String>();
                this.headers.put(name, vals);
            }
            vals.add(value);
        }

        public void jsFunction_putHeader(String name, String value) {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(value);
            this.headers.put(name, vals);
        }

        public int jsFunction_headerListSize(String name) {
            List<String> vals = this.headers.get(name);
            if (vals == null || vals.size() == 0) {
                return 0;
            }
            return vals.size();
        }

        public int jsFunction_headersSize() {
            int sz = 0;
            for (List<String> hList : this.headers.values()) {
                sz += hList.size();
            }
            return sz;
        }

        public String jsFunction_header0(String name) {
            return this.jsFunction_header(name, 0);
        }

        public List<String> jsFunction_headers(String name) {
            int sz = this.jsFunction_headerListSize(name);
            if (sz > 0) {
                return this.headers.get(name);
            }
            return new ArrayList<String>();
        }

        public String jsFunction_header(String name, int pos) {
            if (this.jsFunction_headerListSize(name) > 0) {
                return this.headers.get(name).get(pos);
            }
            return null;
        }
    }
}

