/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import smartrics.rest.client.RestResponse;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapterFactory;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.LetHandler;
import smartrics.rest.fitnesse.fixture.support.Tools;

public class LetBodyHandler
implements LetHandler {
    @Override
    public String handle(RestResponse response, Object expressionContext, String expression) {
        Map namespaceContext = (Map)expressionContext;
        String contentTypeString = response.getContentType();
        String charset = response.getCharset();
        ContentType contentType = ContentType.parse(contentTypeString);
        BodyTypeAdapter bodyTypeAdapter = BodyTypeAdapterFactory.getBodyTypeAdapter(contentType, charset);
        String body = bodyTypeAdapter.toXmlString(response.getBody());
        if (body == null) {
            return null;
        }
        String val = null;
        try {
            NodeList list = Tools.extractXPath(namespaceContext, expression, body);
            Node item = list.item(0);
            if (item != null) {
                val = item.getTextContent();
            }
        }
        catch (IllegalArgumentException e) {
            val = (String)Tools.extractXPath(namespaceContext, expression, body, XPathConstants.STRING, charset);
        }
        if (val != null) {
            val = val.trim();
        }
        return val;
    }
}

