/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture;

import fit.ActionFixture;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.FitFailureException;
import smartrics.rest.fitnesse.fixture.support.CellFormatter;
import smartrics.rest.fitnesse.fixture.support.CellWrapper;
import smartrics.rest.fitnesse.fixture.support.RestDataTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.Tools;

public class FitFormatter
implements CellFormatter<Parse> {
    private ActionFixture fixture;
    private boolean displayActual;
    private int minLenForToggle = -1;
    private boolean displayAbsoluteURLInFull;

    public void setActionFixtureDelegate(ActionFixture f) {
        this.fixture = f;
    }

    @Override
    public boolean isDisplayActual() {
        return this.displayActual;
    }

    @Override
    public void setMinLengthForToggleCollapse(int minLen) {
        this.minLenForToggle = minLen;
    }

    @Override
    public void setDisplayActual(boolean d) {
        this.displayActual = d;
    }

    @Override
    public void setDisplayAbsoluteURLInFull(boolean displayAbsoluteURLInFull) {
        this.displayAbsoluteURLInFull = displayAbsoluteURLInFull;
    }

    @Override
    public void exception(CellWrapper<Parse> cell, String exceptionMessage) {
        Parse wrapped = cell.getWrapped();
        this.fixture.exception(wrapped, (Throwable)new FitFailureException(exceptionMessage));
    }

    @Override
    public void exception(CellWrapper<Parse> cell, Throwable exception) {
        Parse wrapped = cell.getWrapped();
        this.fixture.exception(wrapped, exception);
    }

    @Override
    public void check(CellWrapper<Parse> valueCell, RestDataTypeAdapter adapter) {
        valueCell.body(Tools.toHtml(valueCell.body()));
        this.fixture.check(valueCell.getWrapped(), (TypeAdapter)adapter);
    }

    @Override
    public String label(String string) {
        return ActionFixture.label((String)string);
    }

    @Override
    public void wrong(CellWrapper<Parse> expected, RestDataTypeAdapter typeAdapter) {
        String expectedContent = expected.body();
        String body = Tools.makeContentForWrongCell(expectedContent, typeAdapter, this, this.minLenForToggle);
        expected.body(body);
        this.fixture.wrong(expected.getWrapped());
    }

    @Override
    public void right(CellWrapper<Parse> expected, RestDataTypeAdapter typeAdapter) {
        String expectedContent = expected.body();
        expected.body(Tools.makeContentForRightCell(expectedContent, typeAdapter, this, this.minLenForToggle));
        this.fixture.right(expected.getWrapped());
    }

    @Override
    public String gray(String string) {
        return ActionFixture.gray((String)Tools.toHtml(string));
    }

    @Override
    public void asLink(CellWrapper<Parse> cell, String resolvedUrl, String link, String text) {
        String actualText = text;
        String parsed = null;
        if (this.displayAbsoluteURLInFull && (parsed = Tools.fromSimpleTag(resolvedUrl)).trim().startsWith("http")) {
            actualText = parsed;
        }
        cell.body(Tools.toHtmlLink(link, actualText));
    }

    @Override
    public String fromRaw(String text) {
        return text;
    }
}

