/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture;

import fit.ActionFixture;
import fit.Parse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartrics.rest.fitnesse.fixture.FitFormatter;
import smartrics.rest.fitnesse.fixture.FitRow;
import smartrics.rest.fitnesse.fixture.RestFixture;
import smartrics.rest.fitnesse.fixture.support.CellFormatter;
import smartrics.rest.fitnesse.fixture.support.Config;
import smartrics.rest.fitnesse.fixture.support.RowWrapper;
import smartrics.rest.fitnesse.fixture.support.Tools;
import smartrics.rest.fitnesse.fixture.support.Url;

public class FitRestFixture
extends ActionFixture {
    private static final Logger LOG = LoggerFactory.getLogger(FitRestFixture.class);
    private RestFixture restFixture;

    public String toString() {
        return this.restFixture.toString();
    }

    public String getLastEvaluation() {
        return this.restFixture.getLastEvaluation();
    }

    public String getBaseUrl() {
        return this.restFixture.getBaseUrl();
    }

    public void baseUrl(String url) {
        this.setBaseUrl(new Url(url));
    }

    public void setBaseUrl(Url url) {
        this.restFixture.setBaseUrl(url);
    }

    public Map<String, String> getDefaultHeaders() {
        return this.restFixture.getDefaultHeaders();
    }

    public CellFormatter<?> getFormatter() {
        return this.restFixture.getFormatter();
    }

    public void setMultipartFileName() {
        this.restFixture.setMultipartFileName();
    }

    public String getMultipartFileName() {
        return this.restFixture.getMultipartFileName();
    }

    public void setFileName() {
        this.restFixture.setFileName();
    }

    public String getFileName() {
        return this.restFixture.getFileName();
    }

    public void setMultipartFileParameterName() {
        this.restFixture.setMultipartFileParameterName();
    }

    public String getMultipartFileParameterName() {
        return this.restFixture.getMultipartFileParameterName();
    }

    public void setBody() {
        this.restFixture.setBody();
    }

    public void setHeader() {
        this.restFixture.setHeader();
    }

    public void setHeaders() {
        this.restFixture.setHeaders();
    }

    public void PUT() {
        this.restFixture.PUT();
    }

    public void GET() {
        this.restFixture.GET();
    }

    public void DELETE() {
        this.restFixture.DELETE();
    }

    public void POST() {
        this.restFixture.POST();
    }

    public void HEAD() {
        this.restFixture.HEAD();
    }

    public void OPTIONS() {
        this.restFixture.OPTIONS();
    }

    public void TRACE() {
        this.restFixture.TRACE();
    }

    public void let() {
        this.restFixture.let();
    }

    public void comment() {
        this.restFixture.comment();
    }

    public void evalJs() {
        this.restFixture.evalJs();
    }

    public void processRow(RowWrapper<?> currentRow) {
        this.restFixture.processRow(currentRow);
    }

    public Map<String, String> getHeaders() {
        return this.restFixture.getHeaders();
    }

    public void doCells(Parse parse) {
        if (this.restFixture == null) {
            this.restFixture = new RestFixture();
            this.restFixture.setConfig(Config.getConfig(this.getConfigNameFromArgs()));
            String url = this.getBaseUrlFromArgs();
            if (url != null) {
                this.restFixture.setBaseUrl(new Url(Tools.fromSimpleTag(url)));
            }
            this.restFixture.initialize(RestFixture.Runner.FIT);
            ((FitFormatter)this.restFixture.getFormatter()).setActionFixtureDelegate(this);
        }
        FitRow currentRow = new FitRow(parse);
        try {
            this.restFixture.processRow(currentRow);
        }
        catch (Exception exception) {
            LOG.error("Exception when processing row " + currentRow.getCell(0).text(), (Throwable)exception);
            this.restFixture.getFormatter().exception(currentRow.getCell(0), exception);
        }
    }

    protected String getConfigNameFromArgs() {
        if (this.args.length >= 2) {
            return this.args[1];
        }
        return null;
    }

    protected String getBaseUrlFromArgs() {
        if (this.args.length > 0) {
            return this.args[0];
        }
        return null;
    }

    public Config getConfig() {
        return this.restFixture.getConfig();
    }
}

