/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smartrics.rest.client.RestData;
import smartrics.rest.fitnesse.fixture.support.Config;
import smartrics.rest.fitnesse.fixture.support.Tools;

public enum ContentType {
    XML,
    JSON,
    TEXT,
    JS;

    private static Map<String, ContentType> contentTypeToEnum;

    public List<String> toMime() {
        ArrayList<String> types = new ArrayList<String>();
        for (Map.Entry<String, ContentType> e : contentTypeToEnum.entrySet()) {
            if (!e.getValue().equals((Object)this)) continue;
            types.add(e.getKey());
        }
        return types;
    }

    public static ContentType typeFor(String t) {
        ContentType r = contentTypeToEnum.get(t);
        if (r == null) {
            r = contentTypeToEnum.get("default");
        }
        return r;
    }

    public static void config(Config config) {
        RestData.DEFAULT_ENCODING = config.get("restfixture.content.default.charset", Charset.defaultCharset().name());
        String htmlConfig = config.get("restfixture.content.handlers.map", "");
        String configStr = Tools.fromHtml(htmlConfig);
        Map<String, String> map = Tools.convertStringToMap(configStr, "=", "\n", true);
        for (Map.Entry<String, String> e : map.entrySet()) {
            String value = e.getValue();
            String enumName = value.toUpperCase();
            ContentType ct = ContentType.valueOf(enumName);
            if (null == ct) {
                ContentType[] values = ContentType.values();
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                for (ContentType cType : values) {
                    sb.append("'").append(cType.toString()).append("' ");
                }
                sb.append("]");
                throw new IllegalArgumentException("I don't know how to handle " + value + ". Use one of " + values);
            }
            contentTypeToEnum.put(e.getKey(), ct);
        }
    }

    public static void resetDefaultMapping() {
        contentTypeToEnum.clear();
        contentTypeToEnum.put("default", XML);
        contentTypeToEnum.put("application/xml", XML);
        contentTypeToEnum.put("application/json", JSON);
        contentTypeToEnum.put("text/plain", TEXT);
        contentTypeToEnum.put("application/x-javascript", JS);
    }

    public static ContentType parse(String contentTypeString) {
        ContentType ret;
        String c = contentTypeString;
        if (c == null) {
            return contentTypeToEnum.get("default");
        }
        int pos = contentTypeString.indexOf(";");
        if (pos > 0) {
            c = contentTypeString.substring(0, pos).trim();
        }
        if ((ret = contentTypeToEnum.get(c)) == null) {
            return contentTypeToEnum.get("default");
        }
        return ret;
    }

    static {
        contentTypeToEnum = new HashMap<String, ContentType>();
        ContentType.resetDefaultMapping();
    }
}

