/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smartrics.rest.fitnesse.fixture.RunnerVariablesProvider;
import smartrics.rest.fitnesse.fixture.support.Config;
import smartrics.rest.fitnesse.fixture.support.JavascriptWrapper;
import smartrics.rest.fitnesse.fixture.support.Tools;
import smartrics.rest.fitnesse.fixture.support.XPathBodyTypeAdapter;

public class JSONBodyTypeAdapter
extends XPathBodyTypeAdapter {
    private final Map<String, String> imports;
    private final JavascriptWrapper wrapper;
    private boolean forceJsEvaluation = false;

    public JSONBodyTypeAdapter(RunnerVariablesProvider variablesProvider, Config config) {
        this.wrapper = new JavascriptWrapper(variablesProvider, config);
        this.imports = config.getAsMap("restfixture.javascript.imports.map", new HashMap<String, String>());
    }

    @Override
    protected boolean eval(String expr, String json) {
        if (!this.forceJsEvaluation && Tools.isValidXPath(this.getContext(), expr) && !this.wrapper.looksLikeAJsExpression(expr)) {
            throw new IllegalArgumentException("XPath expectations in JSON content are not supported anymore. Please use JavaScript expressions.");
        }
        Object exprResult = this.wrapper.evaluateExpression(json, expr, this.imports);
        if (exprResult == null) {
            return false;
        }
        return Boolean.parseBoolean(exprResult.toString());
    }

    @Override
    public Object parse(String possibleJsContent) throws Exception {
        if (possibleJsContent == null || !possibleJsContent.trim().contains("/* javascript */")) {
            this.forceJsEvaluation = false;
            return super.parse(possibleJsContent);
        }
        this.forceJsEvaluation = true;
        return Tools.fromHtml(possibleJsContent.trim());
    }

    @Override
    public boolean equals(Object expected, Object actual) {
        if (this.checkNoBody(expected)) {
            return this.checkNoBody(actual);
        }
        if (this.checkNoBody(actual)) {
            return this.checkNoBody(expected);
        }
        if (expected instanceof List) {
            return super.equals(expected, actual);
        }
        boolean result = false;
        if (expected instanceof String && !(result = this.eval(expected.toString(), actual.toString()))) {
            this.addError("not found: '" + expected.toString() + "'");
        }
        return result;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null || obj.toString().trim().equals("")) {
            return "no-body";
        }
        return obj.toString();
    }

    @Override
    public String toXmlString(String content) {
        return Tools.fromJSONtoXML(content);
    }
}

