/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.NodeList;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.Tools;

public class XPathBodyTypeAdapter
extends BodyTypeAdapter {
    public boolean equals(Object expected, Object actual) {
        if (this.checkNoBody(expected)) {
            return this.checkNoBody(actual);
        }
        if (this.checkNoBody(actual)) {
            return this.checkNoBody(expected);
        }
        List expressions = (List)expected;
        for (String expr : expressions) {
            try {
                boolean b = this.eval(expr, actual.toString());
                if (b) continue;
                this.addError("not found: '" + expr + "'");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot evaluate '" + expr + "' in " + actual.toString(), e);
            }
        }
        return this.getErrors().size() == 0;
    }

    protected boolean eval(String expr, String content) {
        try {
            NodeList ret = Tools.extractXPath(this.getContext(), expr, content, this.getCharset());
            return ret != null && ret.getLength() != 0;
        }
        catch (IllegalArgumentException e) {
            Boolean b = (Boolean)Tools.extractXPath(this.getContext(), expr, content, XPathConstants.BOOLEAN, this.getCharset());
            return b;
        }
    }

    public Object parse(String expectedListOfXpathsAsString) throws Exception {
        String[] nvpArray;
        ArrayList<String> expectedXPathAsList = new ArrayList<String>();
        if (expectedListOfXpathsAsString == null) {
            return expectedXPathAsList;
        }
        String expStr = expectedListOfXpathsAsString.trim();
        if ("no-body".equals(expStr)) {
            return expectedXPathAsList;
        }
        if ("".equals(expStr)) {
            return expectedXPathAsList;
        }
        expStr = Tools.fromHtml(expStr);
        for (String nvp : nvpArray = expStr.split("\n")) {
            if ("".equals(nvp.trim())) continue;
            expectedXPathAsList.add(nvp.trim());
        }
        return expectedXPathAsList;
    }

    @Override
    public String toXmlString(String content) {
        return content;
    }
}

