/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlternateContactType {
    BILLING("BILLING"),
    OPERATIONS("OPERATIONS"),
    SECURITY("SECURITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlternateContactType> VALUE_MAP;
    private final String value;

    private AlternateContactType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlternateContactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlternateContactType> knownValues() {
        EnumSet<AlternateContactType> knownValues = EnumSet.allOf(AlternateContactType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlternateContactType.class, AlternateContactType::toString);
    }
}

