/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalableTargetsResponse
extends ApplicationAutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalableTargetsResponse> {
    private static final SdkField<List<ScalableTarget>> SCALABLE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalableTargets").getter(DescribeScalableTargetsResponse.getter(DescribeScalableTargetsResponse::scalableTargets)).setter(DescribeScalableTargetsResponse.setter(Builder::scalableTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalableTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalableTargetsResponse.getter(DescribeScalableTargetsResponse::nextToken)).setter(DescribeScalableTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALABLE_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScalableTargetsResponse.memberNameToFieldInitializer();
    private final List<ScalableTarget> scalableTargets;
    private final String nextToken;

    private DescribeScalableTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.scalableTargets = builder.scalableTargets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScalableTargets() {
        return this.scalableTargets != null && !(this.scalableTargets instanceof SdkAutoConstructList);
    }

    public final List<ScalableTarget> scalableTargets() {
        return this.scalableTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalableTargets() ? this.scalableTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsResponse)) {
            return false;
        }
        DescribeScalableTargetsResponse other = (DescribeScalableTargetsResponse)((Object)obj);
        return this.hasScalableTargets() == other.hasScalableTargets() && Objects.equals(this.scalableTargets(), other.scalableTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalableTargetsResponse").add("ScalableTargets", this.hasScalableTargets() ? this.scalableTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalableTargets": {
                return Optional.ofNullable(clazz.cast(this.scalableTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScalableTargets", SCALABLE_TARGETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalableTargetsResponse, T> g) {
        return obj -> g.apply((DescribeScalableTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScalableTarget> scalableTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalableTargetsResponse model) {
            super(model);
            this.scalableTargets(model.scalableTargets);
            this.nextToken(model.nextToken);
        }

        public final List<ScalableTarget.Builder> getScalableTargets() {
            List<ScalableTarget.Builder> result = ScalableTargetsCopier.copyToBuilder(this.scalableTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalableTargets(Collection<ScalableTarget.BuilderImpl> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copyFromBuilder(scalableTargets);
        }

        @Override
        public final Builder scalableTargets(Collection<ScalableTarget> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copy(scalableTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(ScalableTarget ... scalableTargets) {
            this.scalableTargets(Arrays.asList(scalableTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(Consumer<ScalableTarget.Builder> ... scalableTargets) {
            this.scalableTargets(Stream.of(scalableTargets).map(c -> (ScalableTarget)((ScalableTarget.Builder)ScalableTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScalableTargetsResponse build() {
            return new DescribeScalableTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalableTargetsResponse> {
        public Builder scalableTargets(Collection<ScalableTarget> var1);

        public Builder scalableTargets(ScalableTarget ... var1);

        public Builder scalableTargets(Consumer<ScalableTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

