/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalableTargetsResponse
extends ApplicationAutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalableTargetsResponse> {
    private static final SdkField<List<ScalableTarget>> SCALABLE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScalableTargetsResponse.getter(DescribeScalableTargetsResponse::scalableTargets)).setter(DescribeScalableTargetsResponse.setter(Builder::scalableTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalableTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalableTargetsResponse.getter(DescribeScalableTargetsResponse::nextToken)).setter(DescribeScalableTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALABLE_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScalableTarget> scalableTargets;
    private final String nextToken;

    private DescribeScalableTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.scalableTargets = builder.scalableTargets;
        this.nextToken = builder.nextToken;
    }

    public List<ScalableTarget> scalableTargets() {
        return this.scalableTargets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsResponse)) {
            return false;
        }
        DescribeScalableTargetsResponse other = (DescribeScalableTargetsResponse)((Object)obj);
        return Objects.equals(this.scalableTargets(), other.scalableTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScalableTargetsResponse").add("ScalableTargets", this.scalableTargets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalableTargets": {
                return Optional.ofNullable(clazz.cast(this.scalableTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalableTargetsResponse, T> g) {
        return obj -> g.apply((DescribeScalableTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScalableTarget> scalableTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalableTargetsResponse model) {
            super(model);
            this.scalableTargets(model.scalableTargets);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScalableTarget.Builder> getScalableTargets() {
            return this.scalableTargets != null ? (Collection)this.scalableTargets.stream().map(ScalableTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalableTargets(Collection<ScalableTarget> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copy(scalableTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(ScalableTarget ... scalableTargets) {
            this.scalableTargets(Arrays.asList(scalableTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(Consumer<ScalableTarget.Builder> ... scalableTargets) {
            this.scalableTargets(Stream.of(scalableTargets).map(c -> (ScalableTarget)((ScalableTarget.Builder)ScalableTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalableTargets(Collection<ScalableTarget.BuilderImpl> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copyFromBuilder(scalableTargets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalableTargetsResponse build() {
            return new DescribeScalableTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalableTargetsResponse> {
        public Builder scalableTargets(Collection<ScalableTarget> var1);

        public Builder scalableTargets(ScalableTarget ... var1);

        public Builder scalableTargets(Consumer<ScalableTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

