/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivitiesCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingActivitiesResponse
extends ApplicationAutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
    private static final SdkField<List<ScalingActivity>> SCALING_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScalingActivitiesResponse.getter(DescribeScalingActivitiesResponse::scalingActivities)).setter(DescribeScalingActivitiesResponse.setter(Builder::scalingActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingActivitiesResponse.getter(DescribeScalingActivitiesResponse::nextToken)).setter(DescribeScalingActivitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_ACTIVITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScalingActivity> scalingActivities;
    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingActivities = builder.scalingActivities;
        this.nextToken = builder.nextToken;
    }

    public List<ScalingActivity> scalingActivities() {
        return this.scalingActivities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingActivities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse)((Object)obj);
        return Objects.equals(this.scalingActivities(), other.scalingActivities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScalingActivitiesResponse").add("ScalingActivities", this.scalingActivities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingActivities": {
                return Optional.ofNullable(clazz.cast(this.scalingActivities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingActivitiesResponse, T> g) {
        return obj -> g.apply((DescribeScalingActivitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScalingActivity> scalingActivities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            super(model);
            this.scalingActivities(model.scalingActivities);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScalingActivity.Builder> getScalingActivities() {
            return this.scalingActivities != null ? (Collection)this.scalingActivities.stream().map(ScalingActivity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingActivities(Collection<ScalingActivity> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copy(scalingActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(ScalingActivity ... scalingActivities) {
            this.scalingActivities(Arrays.asList(scalingActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(Consumer<ScalingActivity.Builder> ... scalingActivities) {
            this.scalingActivities(Stream.of(scalingActivities).map(c -> (ScalingActivity)((ScalingActivity.Builder)ScalingActivity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingActivities(Collection<ScalingActivity.BuilderImpl> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copyFromBuilder(scalingActivities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        public Builder scalingActivities(Collection<ScalingActivity> var1);

        public Builder scalingActivities(ScalingActivity ... var1);

        public Builder scalingActivities(Consumer<ScalingActivity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

