/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ResourceIdsMaxLen1600Copier;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingPoliciesRequest
extends ApplicationAutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeScalingPoliciesRequest> {
    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScalingPoliciesRequest.getter(DescribeScalingPoliciesRequest::policyNames)).setter(DescribeScalingPoliciesRequest.setter(Builder::policyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingPoliciesRequest.getter(DescribeScalingPoliciesRequest::serviceNamespaceAsString)).setter(DescribeScalingPoliciesRequest.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingPoliciesRequest.getter(DescribeScalingPoliciesRequest::resourceId)).setter(DescribeScalingPoliciesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingPoliciesRequest.getter(DescribeScalingPoliciesRequest::scalableDimensionAsString)).setter(DescribeScalingPoliciesRequest.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeScalingPoliciesRequest.getter(DescribeScalingPoliciesRequest::maxResults)).setter(DescribeScalingPoliciesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingPoliciesRequest.getter(DescribeScalingPoliciesRequest::nextToken)).setter(DescribeScalingPoliciesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAMES_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> policyNames;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeScalingPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.policyNames = builder.policyNames;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPoliciesRequest)) {
            return false;
        }
        DescribeScalingPoliciesRequest other = (DescribeScalingPoliciesRequest)((Object)obj);
        return Objects.equals(this.policyNames(), other.policyNames()) && Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScalingPoliciesRequest").add("PolicyNames", this.policyNames()).add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyNames": {
                return Optional.ofNullable(clazz.cast(this.policyNames()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPoliciesRequest, T> g) {
        return obj -> g.apply((DescribeScalingPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPoliciesRequest model) {
            super(model);
            this.policyNames(model.policyNames);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = ResourceIdsMaxLen1600Copier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = ResourceIdsMaxLen1600Copier.copy(policyNames);
        }

        public final String getServiceNamespaceAsString() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimensionAsString() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingPoliciesRequest build() {
            return new DescribeScalingPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingPoliciesRequest> {
        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

